/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.CanaisAPI;
import pt.sapo.sapofe.api.CanaisFacetsAPI;
import pt.sapo.sapofe.api.CanaisListAPI;
import pt.sapo.sapofe.api.CategoriesList;
import pt.sapo.sapofe.api.MainMenuApiList;
import pt.sapo.sapofe.api.Newspaper;
import pt.sapo.sapofe.api.saponoticias.News;
import pt.sapo.sapofe.api.sapovideos.SAPOVideos;
import pt.sapo.sapofe.api.sapovideos.Video;
import pt.sapo.sapofe.api.tripadvisor.TripAdvFastSearchResp;
import pt.sapo.sapofe.api.tripadvisor.TripAdvResp;
import pt.sapo.sapofe.tools.Constants;
import pt.sapo.sapofe.tools.JsonCanaisApiResponseHandler;
import pt.sapo.sapofe.tools.JsonCanaisFacetsApiResponseHandler;
import pt.sapo.sapofe.tools.JsonCanaisListApiResponseHandler;
import pt.sapo.sapofe.tools.JsonCategoriesApiResponseHandler;
import pt.sapo.sapofe.tools.JsonListCanaisApiResponseHandler;
import pt.sapo.sapofe.tools.JsonMainMenuApiResponseHandler;
import pt.sapo.sapofe.tools.JsonNewsListApiResponseHandler;
import pt.sapo.sapofe.tools.JsonNewspaperListApiResponseHandler;
import pt.sapo.sapofe.tools.JsonSAPOVideosResponseHandler;
import pt.sapo.sapofe.tools.JsonSAPOVideosSingleResponseHandler;
import pt.sapo.sapofe.tools.JsonTravelAdvApiResponseHandler;
import pt.sapo.sapofe.tools.JsonTravelAdvFastSearchApiResponseHandler;

public class HttpClient {
    private static Logger log = LoggerFactory.getLogger(HttpClient.class);
    static PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpclient;
    private final JsonSAPOVideosSingleResponseHandler rsp_sapovideos_handler = new JsonSAPOVideosSingleResponseHandler();
    private final JsonSAPOVideosResponseHandler rsp_sapovideos_list_handler = new JsonSAPOVideosResponseHandler();
    private final JsonMainMenuApiResponseHandler rsp_main_menu_handler = new JsonMainMenuApiResponseHandler();
    private final JsonCategoriesApiResponseHandler rsp_categories_handler = new JsonCategoriesApiResponseHandler();
    private final JsonCanaisApiResponseHandler rsp_canais_handler = new JsonCanaisApiResponseHandler();
    private final JsonListCanaisApiResponseHandler rsp_list_canais_handler = new JsonListCanaisApiResponseHandler();
    private final JsonCanaisListApiResponseHandler rsp_canais_list_handler = new JsonCanaisListApiResponseHandler();
    private final JsonCanaisFacetsApiResponseHandler rsp_canais_facets_handler = new JsonCanaisFacetsApiResponseHandler();
    private final JsonNewspaperListApiResponseHandler rsp_newspaper_list_handler = new JsonNewspaperListApiResponseHandler();
    private final JsonNewsListApiResponseHandler rsp_news_list_handler = new JsonNewsListApiResponseHandler();
    private final JsonTravelAdvApiResponseHandler rsp_trip_adv_handler = new JsonTravelAdvApiResponseHandler();
    private final JsonTravelAdvFastSearchApiResponseHandler rsp_trip_adv_fast_search_handler = new JsonTravelAdvFastSearchApiResponseHandler();

    static {
        cm.setMaxTotal(10);
        String value = System.getenv("http_proxy");
        RequestConfig config = null;
        int socketTimeout = Integer.parseInt(Constants.properties.getProperty("http.request.socket.timeout", "8000"));
        int connectTimeout = Integer.parseInt(Constants.properties.getProperty("http.request.connect.timeout", "5000"));
        log.info(String.format("socketTimeout [ %s ] ", socketTimeout));
        log.info(String.format("connectTimeout [ %s ] ", connectTimeout));
        if (!StringUtils.isEmpty((CharSequence)value)) {
            HttpHost proxy = new HttpHost(StringUtils.substringBefore((String)value, (String)":"), Integer.parseInt(StringUtils.substringAfter((String)value, (String)":")), "http");
            config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(10000).setConnectTimeout(5000).build();
        } else {
            config = RequestConfig.custom().setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).build();
        }
        httpclient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    private SAPOVideos doHttpRequestSAPOVideos(HttpRequestBase httpget, JsonSAPOVideosResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (SAPOVideos)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_sapovideos_list_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to SAPO Videos - %s%n", r.getMessage()));
            return null;
        }
    }

    public SAPOVideos doHttpGetSAPOVideos(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestSAPOVideos((HttpRequestBase)httpget, this.rsp_sapovideos_list_handler);
    }

    private Video doHttpRequestSAPOVideosSingle(HttpRequestBase httpget, JsonSAPOVideosSingleResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (Video)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_sapovideos_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to SAPO Videos - %s%n", r.getMessage()));
            return null;
        }
    }

    public Video doHttpGetSAPOVideosSingle(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestSAPOVideosSingle((HttpRequestBase)httpget, this.rsp_sapovideos_handler);
    }

    private MainMenuApiList doHttpRequestMainMenuAPI(HttpRequestBase httpget, JsonMainMenuApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (MainMenuApiList)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_main_menu_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to MENU API - %s%n", r.getMessage()));
            return null;
        }
    }

    public MainMenuApiList doHttpGetMainMenuAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestMainMenuAPI((HttpRequestBase)httpget, this.rsp_main_menu_handler);
    }

    private CategoriesList doHttpRequestCategoriesAPI(HttpRequestBase httpget, JsonCategoriesApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            CategoriesList result = (CategoriesList)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_categories_handler, (HttpContext)context);
            log.info(String.format("TIME: [ %sms ] \t REQUEST: %s ", System.currentTimeMillis() - startTime, httpget.getURI()));
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to CATEGORIES API - %s%n", r.getMessage()));
            return null;
        }
    }

    public CategoriesList doHttpGetCategoriesAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCategoriesAPI((HttpRequestBase)httpget, this.rsp_categories_handler);
    }

    private CanaisAPI doHttpRequestCanaisAPI(HttpRequestBase httpget, JsonCanaisApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            CanaisAPI result = (CanaisAPI)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_canais_handler, (HttpContext)context);
            log.info(String.format("TIME: [ %sms ] \t REQUEST: %s ", System.currentTimeMillis() - startTime, httpget.getURI()));
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Canais API - %s - [ %s ]%n", r.getMessage(), httpget.getURI()));
            return null;
        }
    }

    public CanaisAPI doHttpGetCanaisAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCanaisAPI((HttpRequestBase)httpget, this.rsp_canais_handler);
    }

    private ArrayList<CanaisAPI> doHttpRequestListCanaisAPI(HttpRequestBase httpget, JsonListCanaisApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            ArrayList result = (ArrayList)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_list_canais_handler, (HttpContext)context);
            log.info(String.format("TIME: [ %sms ] \t REQUEST: %s ", System.currentTimeMillis() - startTime, httpget.getURI()));
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Canais API - %s - [ %s ]%n", r.getMessage(), httpget.getURI()));
            return null;
        }
    }

    public ArrayList<CanaisAPI> doHttpGetListCanaisAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestListCanaisAPI((HttpRequestBase)httpget, this.rsp_list_canais_handler);
    }

    private CanaisListAPI doHttpRequestCanaisListAPI(HttpRequestBase httpget, JsonCanaisListApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            CanaisListAPI result = (CanaisListAPI)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_canais_list_handler, (HttpContext)context);
            log.info(String.format("TIME: [ %sms ] \t REQUEST: %s ", System.currentTimeMillis() - startTime, httpget.getURI()));
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Canais API - %s - [ %s ]%n", r.getMessage(), httpget.getURI()));
            return null;
        }
    }

    public CanaisListAPI doHttpGetCanaisListAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCanaisListAPI((HttpRequestBase)httpget, this.rsp_canais_list_handler);
    }

    private CanaisFacetsAPI doHttpRequestCanaisFacetsAPI(HttpRequestBase httpget, JsonCanaisFacetsApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (CanaisFacetsAPI)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_canais_facets_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Canais API - %s - [ %s ]%n", r.getMessage(), httpget.getURI()));
            return null;
        }
    }

    public CanaisFacetsAPI doHttpGetCanaisFacetsAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCanaisFacetsAPI((HttpRequestBase)httpget, this.rsp_canais_facets_handler);
    }

    private Newspaper[] doHttpRequestNewspaperListAPI(HttpRequestBase httpget, JsonNewspaperListApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (Newspaper[])httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_newspaper_list_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Newspaper API - %s%n", r.getMessage()));
            return null;
        }
    }

    public Newspaper[] doHttpGetNewspaperAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestNewspaperListAPI((HttpRequestBase)httpget, this.rsp_newspaper_list_handler);
    }

    private News[] doHttpRequestNewsListAPI(HttpRequestBase httpget, JsonNewsListApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (News[])httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_news_list_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to News API - %s%n", r.getMessage()));
            return null;
        }
    }

    public News[] doHttpGetNews(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestNewsListAPI((HttpRequestBase)httpget, this.rsp_news_list_handler);
    }

    private TripAdvResp doHttpRequestTripAdvAPI(HttpRequestBase httpget, JsonTravelAdvApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (TripAdvResp)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_trip_adv_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to TripAdvisorAPI API - %s%n", r.getMessage()));
            return null;
        }
    }

    public TripAdvResp doHttpGetTripAdvAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestTripAdvAPI((HttpRequestBase)httpget, this.rsp_trip_adv_handler);
    }

    private TripAdvFastSearchResp doHttpRequestTripAdvFastSearchAPI(HttpRequestBase httpget, JsonTravelAdvFastSearchApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (TripAdvFastSearchResp)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_trip_adv_fast_search_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to TripAdvisorAPI API - %s%n", r.getMessage()));
            return null;
        }
    }

    public TripAdvFastSearchResp doHttpGetTripAdvFastSearchAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestTripAdvFastSearchAPI((HttpRequestBase)httpget, this.rsp_trip_adv_fast_search_handler);
    }
}

