/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api.sapodesporto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.text.DateUtil;
import pt.sapo.sapofe.api.sapodesporto.Controversy;
import pt.sapo.sapofe.api.sapodesporto.LeagueTable;
import pt.sapo.sapofe.api.sapodesporto.Membership;
import pt.sapo.sapofe.api.sapodesporto.Metadata;
import pt.sapo.sapofe.api.sapodesporto.RecordItem;
import pt.sapo.sapofe.api.sapodesporto.Season;
import pt.sapo.sapofe.api.sapodesporto.Statistics;
import pt.sapo.sapofe.api.sapodesporto.Status;
import pt.sapo.sapofe.api.sapodesporto.Team;
import pt.sapo.sapofe.api.sapodesporto.Trophie;
import pt.sapo.sapofe.tools.Slug;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SportStatisticsApi
implements Serializable {
    private static final long serialVersionUID = -7857448470092971327L;
    @JsonProperty(value="Id")
    private int id;
    @JsonProperty(value="CompetitionSeasonId")
    private int competitionSeasonId;
    @JsonProperty(value="SeasonId")
    private int seasonId;
    @JsonProperty(value="Name")
    private String name;
    private String slug;
    @JsonProperty(value="FullName")
    private String fullName;
    @JsonProperty(value="BirthDate")
    private String birthDate;
    @JsonProperty(value="PhotoUri")
    private String photoUri;
    @JsonProperty(value="Height")
    private float height;
    @JsonProperty(value="Weight")
    private float weight;
    @JsonProperty(value="CurrentTeams")
    private List<Team> currentTeams;
    @JsonProperty(value="Country")
    private Metadata country;
    @JsonProperty(value="BirthCountry")
    private Metadata birthCountry;
    @JsonProperty(value="Position")
    private Metadata position;
    @JsonProperty(value="OfficialName")
    private String officialName;
    @JsonProperty(value="EmblemUri")
    private String emblemUri;
    @JsonProperty(value="HomeKitUri")
    private String homeKitUri;
    @JsonProperty(value="Initials")
    private String initials;
    @JsonProperty(value="FoundationYear")
    private int foundationYear;
    @JsonProperty(value="City")
    private Metadata city;
    @JsonProperty(value="Venue")
    private Metadata venue;
    @JsonProperty(value="Organization")
    private Metadata organization;
    @JsonProperty(value="Role")
    private Status role;
    @JsonProperty(value="CompetitionId")
    private int competitionId;
    @JsonProperty(value="CompetitionName")
    private String competitionName;
    @JsonProperty(value="Trophies")
    private List<Trophie> trophies;
    @JsonProperty(value="ShirtNumber")
    private int shirtNumber;
    @JsonProperty(value="Active")
    private boolean active;
    private boolean isVisible = true;
    @JsonProperty(value="StartDate")
    private String startDate;
    @JsonProperty(value="EndDate")
    private String endDate;
    @JsonProperty(value="Season")
    private Season season;
    @JsonProperty(value="Memberships")
    private List<Membership> Memberships;
    private List<RecordItem> matches;
    private Integer numMatches;
    @JsonProperty(value="RoundId")
    private int roundId;
    @JsonProperty(value="RoundName")
    private String roundName;
    @JsonProperty(value="RoundTypeId")
    private int roundTypeId;
    @JsonProperty(value="LeagueTable")
    private List<LeagueTable> leagueTable;
    @JsonProperty(value="Children")
    private List<SportStatisticsApi> children;
    @JsonProperty(value="Type")
    private Status type;
    @JsonProperty(value="Value")
    private int value;
    @JsonProperty(value="Person")
    private SportStatisticsApi person;
    @JsonProperty(value="MatchId")
    private int matchId;
    @JsonProperty(value="MinuteExtra")
    private int minuteExtra;
    @JsonProperty(value="Minute")
    private int minute;
    @JsonProperty(value="Text")
    private String text;
    @JsonProperty(value="SortOrder")
    private Integer sortOrder;
    @JsonProperty(value="SourceTeam")
    private Status sourceTeam;
    @JsonProperty(value="SourcePerson")
    private Status sourcePerson;
    @JsonProperty(value="TargetTeam")
    private Status targetTeam;
    @JsonProperty(value="TargetPerson")
    private Status targetPerson;
    @JsonProperty(value="MatchPeriod")
    private Status matchPeriod;
    @JsonProperty(value="OccurrenceType")
    private Status occurrenceType;
    private boolean isControversy;
    @JsonProperty(value="VideoUri")
    private String videoUri;
    private String videoRandname;
    @JsonProperty(value="Records")
    private List<SportStatisticsApi> records;
    @JsonProperty(value="Controversy")
    private Controversy controversy;
    @JsonProperty(value="Competition")
    private SportStatisticsApi competition;
    @JsonProperty(value="Statistics")
    private Statistics statistics;
    private String hash;

    @JsonSetter(value="Matches")
    public void setMarchesInternal(JsonNode matchesInternal) {
        ObjectMapper mapper = new ObjectMapper();
        if (matchesInternal != null) {
            if (matchesInternal.isInt()) {
                this.numMatches = matchesInternal.asInt();
            } else if (matchesInternal.isArray()) {
                this.matches = new ArrayList<RecordItem>();
                for (JsonNode matchInternal : matchesInternal) {
                    this.matches.add((RecordItem)mapper.convertValue((Object)matchInternal, RecordItem.class));
                }
            }
        }
    }

    public SportStatisticsApi() {
    }

    public SportStatisticsApi(String st) {
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
        this.setSlug(this.id, this.name);
    }

    public int getCompetitionSeasonId() {
        return this.competitionSeasonId;
    }

    public void setCompetitionSeasonId(int competitionSeasonId) {
        this.competitionSeasonId = competitionSeasonId;
    }

    public int getSeasonId() {
        return this.seasonId;
    }

    public void setSeasonId(int seasonId) {
        this.seasonId = seasonId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setSlug(this.id, this.name);
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(int id, String name) {
        if (id != 0 && name != null) {
            this.slug = String.valueOf(Slug.create(name)) + "-" + id;
        }
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(String birthDate) {
        Date _date = DateUtil.parseISODate((String)birthDate);
        this.birthDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000000", new Locale("pt", "PT")).format(_date);
    }

    public String getPhotoUri() {
        return this.photoUri;
    }

    public void setPhotoUri(String photoUri) {
        this.photoUri = photoUri;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public List<Team> getCurrentTeams() {
        return this.currentTeams;
    }

    public void setCurrentTeams(List<Team> currentTeams) {
        this.currentTeams = currentTeams;
    }

    public Metadata getCountry() {
        return this.country;
    }

    public void setCountry(Metadata country) {
        this.country = country;
    }

    public Metadata getBirthCountry() {
        return this.birthCountry;
    }

    public void setBirthCountry(Metadata birthCountry) {
        this.birthCountry = birthCountry;
    }

    public Metadata getPosition() {
        return this.position;
    }

    public void setPosition(Metadata position) {
        this.position = position;
    }

    public String getOfficialName() {
        return this.officialName;
    }

    public void setOfficialName(String officialName) {
        this.officialName = officialName;
    }

    public String getEmblemUri() {
        return this.emblemUri;
    }

    public void setEmblemUri(String emblemUri) {
        this.emblemUri = emblemUri;
    }

    public String getHomeKitUri() {
        return this.homeKitUri;
    }

    public void setHomeKitUri(String homeKitUri) {
        this.homeKitUri = homeKitUri;
    }

    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        this.initials = initials;
    }

    public int getFoundationYear() {
        return this.foundationYear;
    }

    public void setFoundationYear(int foundationYear) {
        this.foundationYear = foundationYear;
    }

    public Metadata getCity() {
        return this.city;
    }

    public void setCity(Metadata city) {
        this.city = city;
    }

    public Metadata getVenue() {
        return this.venue;
    }

    public void setVenue(Metadata venue) {
        this.venue = venue;
    }

    public Metadata getOrganization() {
        return this.organization;
    }

    public void setOrganization(Metadata organization) {
        this.organization = organization;
    }

    public Status getRole() {
        return this.role;
    }

    public void setRole(Status role) {
        this.role = role;
    }

    public int getCompetitionId() {
        return this.competitionId;
    }

    public void setCompetitionId(int competitionId) {
        this.competitionId = competitionId;
    }

    public String getCompetitionName() {
        return this.competitionName;
    }

    public void setCompetitionName(String competitionName) {
        this.competitionName = competitionName;
    }

    public List<Trophie> getTrophies() {
        return this.trophies;
    }

    public void setTrophies(List<Trophie> trophies) {
        this.trophies = trophies;
    }

    public int getShirtNumber() {
        return this.shirtNumber;
    }

    public void setShirtNumber(int shirtNumber) {
        this.shirtNumber = shirtNumber;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        try {
            startDate = new SimpleDateFormat("yyyy-MM-dd 00:00:00.000000", new Locale("pt")).format(new SimpleDateFormat("yyyy-MM-dd").parse(startDate));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        Date _date = DateUtil.parseISODate((String)endDate);
        this.endDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000000", new Locale("pt", "PT")).format(_date);
    }

    public Season getSeason() {
        return this.season;
    }

    public void setSeason(Season season) {
        this.season = season;
    }

    public List<Membership> getMemberships() {
        return this.Memberships;
    }

    public void setMemberships(List<Membership> memberships) {
        this.Memberships = memberships;
    }

    public List<RecordItem> getMatches() {
        return this.matches;
    }

    public void setMatches(List<RecordItem> matches) {
        this.matches = matches;
    }

    public Integer getNumMatches() {
        return this.numMatches;
    }

    public void setNumMatches(Integer numMatches) {
        this.numMatches = numMatches;
    }

    public int getRoundId() {
        return this.roundId;
    }

    public void setRoundId(int roundId) {
        this.roundId = roundId;
    }

    public String getRoundName() {
        return this.roundName;
    }

    public void setRoundName(String roundName) {
        this.roundName = roundName;
    }

    public int getRoundTypeId() {
        return this.roundTypeId;
    }

    public void setRoundTypeId(int roundTypeId) {
        this.roundTypeId = roundTypeId;
    }

    public List<LeagueTable> getLeagueTable() {
        return this.leagueTable;
    }

    public void setLeagueTable(List<LeagueTable> leagueTable) {
        this.leagueTable = leagueTable;
    }

    public List<SportStatisticsApi> getChildren() {
        return this.children;
    }

    public void setChildren(List<SportStatisticsApi> children) {
        this.children = children;
    }

    public Status getType() {
        return this.type;
    }

    public void setType(Status type) {
        this.type = type;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public SportStatisticsApi getPerson() {
        return this.person;
    }

    public void setPerson(SportStatisticsApi person) {
        this.person = person;
    }

    public int getMatchId() {
        return this.matchId;
    }

    public void setMatchId(int matchId) {
        this.matchId = matchId;
    }

    public int getMinuteExtra() {
        return this.minuteExtra;
    }

    public void setMinuteExtra(int minuteExtra) {
        this.minuteExtra = minuteExtra;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Integer getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(Integer sortOrder) {
        this.sortOrder = sortOrder;
    }

    public Status getSourceTeam() {
        return this.sourceTeam;
    }

    public void setSourceTeam(Status sourceTeam) {
        this.sourceTeam = sourceTeam;
    }

    public Status getSourcePerson() {
        return this.sourcePerson;
    }

    public void setSourcePerson(Status sourcePerson) {
        this.sourcePerson = sourcePerson;
    }

    public Status getTargetTeam() {
        return this.targetTeam;
    }

    public void setTargetTeam(Status targetTeam) {
        this.targetTeam = targetTeam;
    }

    public Status getTargetPerson() {
        return this.targetPerson;
    }

    public void setTargetPerson(Status targetPerson) {
        this.targetPerson = targetPerson;
    }

    public Status getMatchPeriod() {
        return this.matchPeriod;
    }

    public void setMatchPeriod(Status matchPeriod) {
        this.matchPeriod = matchPeriod;
    }

    public Status getOccurrenceType() {
        return this.occurrenceType;
    }

    public void setOccurrenceType(Status occurrenceType) {
        this.occurrenceType = occurrenceType;
    }

    public boolean isControversy() {
        return this.isControversy;
    }

    public void setIsControversy(boolean isControversy) {
        this.isControversy = isControversy;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getVideoUri() {
        return this.videoUri;
    }

    public void setVideoUri(String videoUri) {
        this.videoUri = videoUri;
        String[] videoUriLst = StringUtils.split((String)videoUri, (String)"/");
        this.videoRandname = videoUriLst[videoUriLst.length - 1];
    }

    public String getVideoRandname() {
        return this.videoRandname;
    }

    public void setVideoRandname(String videoRandname) {
        this.videoRandname = videoRandname;
    }

    public List<SportStatisticsApi> getRecords() {
        return this.records;
    }

    public void setRecords(List<SportStatisticsApi> records) {
        this.records = records;
    }

    public Controversy getControversy() {
        return this.controversy;
    }

    public void setControversy(Controversy controversy) {
        controversy.setTotalVoteCount(controversy.getAgreeVoteCount() + controversy.getDisagreeVoteCount());
        if (controversy.getTotalVoteCount() > 0) {
            controversy.setAgreeVotePrecent(controversy.getAgreeVoteCount() * 100 / controversy.getTotalVoteCount());
            controversy.setDisagreeVotePrecent(controversy.getDisagreeVotePrecent() * 100.0f / (float)controversy.getTotalVoteCount());
        }
        this.controversy = controversy;
    }

    public SportStatisticsApi getCompetition() {
        return this.competition;
    }

    public void setCompetition(SportStatisticsApi competition) {
        this.competition = competition;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String toString() {
        return "SportStatisticsApi [id=" + this.id + ", competitionSeasonId=" + this.competitionSeasonId + ", seasonId=" + this.seasonId + ", name=" + this.name + ", slug=" + this.slug + ", fullName=" + this.fullName + ", birthDate=" + this.birthDate + ", photoUri=" + this.photoUri + ", height=" + this.height + ", weight=" + this.weight + ", currentTeams=" + this.currentTeams + ", country=" + this.country + ", birthCountry=" + this.birthCountry + ", position=" + this.position + ", officialName=" + this.officialName + ", emblemUri=" + this.emblemUri + ", homeKitUri=" + this.homeKitUri + ", initials=" + this.initials + ", foundationYear=" + this.foundationYear + ", city=" + this.city + ", venue=" + this.venue + ", organization=" + this.organization + ", role=" + this.role + ", competitionId=" + this.competitionId + ", competitionName=" + this.competitionName + ", trophies=" + this.trophies + ", shirtNumber=" + this.shirtNumber + ", active=" + this.active + ", isVisible=" + this.isVisible + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", season=" + this.season + ", Memberships=" + this.Memberships + ", matches=" + this.matches + ", numMatches=" + this.numMatches + ", roundId=" + this.roundId + ", roundName=" + this.roundName + ", roundTypeId=" + this.roundTypeId + ", leagueTable=" + this.leagueTable + ", children=" + this.children + ", type=" + this.type + ", value=" + this.value + ", person=" + this.person + ", matchId=" + this.matchId + ", minuteExtra=" + this.minuteExtra + ", minute=" + this.minute + ", text=" + this.text + ", sortOrder=" + this.sortOrder + ", sourceTeam=" + this.sourceTeam + ", sourcePerson=" + this.sourcePerson + ", targetTeam=" + this.targetTeam + ", targetPerson=" + this.targetPerson + ", matchPeriod=" + this.matchPeriod + ", occurrenceType=" + this.occurrenceType + ", isControversy=" + this.isControversy + ", videoUri=" + this.videoUri + ", videoRandname=" + this.videoRandname + ", records=" + this.records + ", controversy=" + this.controversy + ", competition=" + this.competition + ", statistics=" + this.statistics + ", hash=" + this.hash + "]";
    }
}

