/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api.sapovideos;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.time.LocalTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import pt.sapo.sapofe.api.sapovideos.UserObj;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class VideoObj
implements Serializable {
    private static final long serialVersionUID = 8222294735711640092L;
    private int vidId;
    private String randname;
    private boolean active;
    private String creationDate;
    private int length;
    private String duration;
    private String subtitle;
    private String title;
    private String synopse;
    private boolean m18;
    private boolean live;
    private String thumb;
    private int contentType;
    private UserObj user;
    private long views;
    private List<VideoObj> related;
    private List<String> tags;

    public int getVidId() {
        return this.vidId;
    }

    public void setVidId(int vidId) {
        this.vidId = vidId;
    }

    public String getRandname() {
        return this.randname;
    }

    public void setRandname(String randname) {
        this.thumb = "//rd.videos.sapo.pt/" + randname + "/pic/560x420";
        this.randname = randname;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
        String duration = LocalTime.ofSecondOfDay(length).toString();
        if (duration.length() < 8) {
            duration = String.valueOf(duration) + ":00";
        }
        if (StringUtils.startsWith((CharSequence)duration, (CharSequence)"00:")) {
            this.duration = StringUtils.substring((String)duration, (int)3);
        }
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSynopse() {
        return this.synopse;
    }

    public void setSynopse(String synopse) {
        this.synopse = synopse;
    }

    public boolean isM18() {
        return this.m18;
    }

    public void setM18(boolean m18) {
        this.m18 = m18;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public String getThumb() {
        return this.thumb;
    }

    public void setThumb(String thumb) {
        this.thumb = thumb;
    }

    public int getContentType() {
        return this.contentType;
    }

    public void setContentType(int contentType) {
        if (contentType == 4) {
            this.live = true;
        }
        this.contentType = contentType;
    }

    public UserObj getUser() {
        return this.user;
    }

    public void setUser(UserObj user) {
        this.user = user;
    }

    public long getViews() {
        return this.views;
    }

    public void setViews(long views) {
        this.views = views;
    }

    public List<VideoObj> getRelated() {
        return this.related;
    }

    public void setRelated(List<VideoObj> related) {
        this.related = related;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String toString() {
        return "VideoObj [vidId=" + this.vidId + ", randname=" + this.randname + ", active=" + this.active + ", creationDate=" + this.creationDate + ", length=" + this.length + ", subtitle=" + this.subtitle + ", title=" + this.title + ", synopse=" + this.synopse + ", m18=" + this.m18 + ", live=" + this.live + ", contentType=" + this.contentType + ", user=" + this.user + ", views=" + this.views + ", related=" + this.related + ", tags=" + this.tags + "]";
    }
}

