/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContentInfo
implements Serializable {
    private static final long serialVersionUID = -8918002593984845304L;
    private static final int WPM = 150;
    private long numWords;
    private Map<String, Integer> readingTime;

    public long getNumWords() {
        return this.numWords;
    }

    public void setNumWords(long numWords) {
        this.numWords = numWords;
        this.readingTime = this.durationFormat(numWords / 150L * 60L);
    }

    public Map<String, Integer> getReadingTime() {
        return this.readingTime;
    }

    public void setReadingTime(Map<String, Integer> readingTime) {
        this.readingTime = readingTime;
    }

    private Map<String, Integer> durationFormat(long longVal) {
        long absSeconds = Math.abs(longVal += 60L);
        int hours = (int)(absSeconds / 3600L);
        int mins = (int)(absSeconds % 3600L / 60L);
        int secs = (int)(absSeconds % 60L);
        HashMap<String, Integer> timeSlices = new HashMap<String, Integer>();
        timeSlices.put("h", hours);
        timeSlices.put("m", mins);
        timeSlices.put("s", secs);
        return timeSlices;
    }

    public String toString() {
        return "ContentInfo [numWords=" + this.numWords + ", readingTime=" + this.readingTime + "]";
    }
}

