/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContentInfo
implements Serializable {
    private static final long serialVersionUID = -8918002593984845304L;
    private static final int WPM = 150;
    private long numWords;
    private long readingTimeMin;
    private Map<String, Integer> readingTime;
    private long durationVideoSeconds;
    private long playVideoTimeMin;
    private Map<String, Integer> playVideoTime;
    private long durationAudioSeconds;
    private long playAudioTimeMin;
    private Map<String, Integer> playAudioTime;
    private int totalPhotos;

    public long getNumWords() {
        return this.numWords;
    }

    public void setNumWords(long numWords) {
        this.numWords = numWords;
        this.readingTime = this.durationFormat(numWords / 150L * 60L);
    }

    public long getReadingTimeMin() {
        return this.readingTimeMin;
    }

    public void setReadingTimeMin(long readingTimeMin) {
        this.readingTimeMin = readingTimeMin;
    }

    public Map<String, Integer> getReadingTime() {
        return this.readingTime;
    }

    public void setReadingTime(Map<String, Integer> readingTime) {
        this.readingTime = readingTime;
    }

    public long getDurationVideoSeconds() {
        return this.durationVideoSeconds;
    }

    public void setDurationVideoSeconds(long durationVideoSeconds) {
        this.durationVideoSeconds = durationVideoSeconds;
        this.playVideoTimeMin = Math.abs(durationVideoSeconds / 60L);
        this.playVideoTime = this.formatDuration(durationVideoSeconds);
    }

    public long getPlayVideoTimeMin() {
        return this.playVideoTimeMin;
    }

    public void setPlayVideoTimeMin(long playVideoTimeMin) {
        this.playVideoTimeMin = playVideoTimeMin;
    }

    public Map<String, Integer> getPlayVideoTime() {
        return this.playVideoTime;
    }

    public void setPlayVideoTime(Map<String, Integer> playVideoTime) {
        this.playVideoTime = playVideoTime;
    }

    public long getDurationAudioSeconds() {
        return this.durationAudioSeconds;
    }

    public void setDurationAudioSeconds(long durationAudioSeconds) {
        this.durationAudioSeconds = durationAudioSeconds;
        this.playAudioTimeMin = Math.abs(durationAudioSeconds / 60L);
        this.playAudioTime = this.formatDuration(durationAudioSeconds);
    }

    public long getPlayAudioTimeMin() {
        return this.playAudioTimeMin;
    }

    public void setPlayAudioTimeMin(long playAudioTimeMin) {
        this.playAudioTimeMin = playAudioTimeMin;
    }

    public Map<String, Integer> getPlayAudioTime() {
        return this.playAudioTime;
    }

    public void setPlayAudioTime(Map<String, Integer> playAudioTime) {
        this.playAudioTime = playAudioTime;
    }

    public int getTotalPhotos() {
        return this.totalPhotos;
    }

    public void setTotalPhotos(int totalPhotos) {
        this.totalPhotos = totalPhotos;
    }

    private Map<String, Integer> durationFormat(long longVal) {
        long absSeconds = Math.abs(longVal += 60L);
        this.readingTimeMin = absSeconds / 60L;
        return this.formatDuration(absSeconds);
    }

    private Map<String, Integer> formatDuration(long seconds) {
        int hours = (int)(seconds / 3600L);
        int mins = (int)(seconds % 3600L / 60L);
        int secs = (int)(seconds % 60L);
        HashMap<String, Integer> timeSlices = new HashMap<String, Integer>();
        timeSlices.put("h", hours);
        timeSlices.put("m", mins);
        timeSlices.put("s", secs);
        return timeSlices;
    }

    public String toString() {
        return "ContentInfo [numWords=" + this.numWords + ", readingTimeMin=" + this.readingTimeMin + ", readingTime=" + this.readingTime + ", durationVideoSeconds=" + this.durationVideoSeconds + ", playVideoTimeMin=" + this.playVideoTimeMin + ", playVideoTime=" + this.playVideoTime + ", durationAudioSeconds=" + this.durationAudioSeconds + ", playAudioTimeMin=" + this.playAudioTimeMin + ", playAudioTime=" + this.playAudioTime + ", totalPhotos=" + this.totalPhotos + "]";
    }
}

