/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.Block;
import pt.sapo.sapofe.api.Categories;
import pt.sapo.sapofe.api.ContentInfo;
import pt.sapo.sapofe.api.DynamicData;
import pt.sapo.sapofe.api.Embed;
import pt.sapo.sapofe.api.Embeds;
import pt.sapo.sapofe.api.Image;
import pt.sapo.sapofe.api.Metadata;
import pt.sapo.sapofe.api.Multimedia;
import pt.sapo.sapofe.api.Tag;
import pt.sapo.sapofe.api.Taxonomies;
import pt.sapo.sapofe.api.Translation;
import pt.sapo.sapofe.tools.JsonConverter;
import pt.sapo.sapofe.tools.Slug;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CanaisAPI
implements Serializable {
    private static final long serialVersionUID = 2421739680001298020L;
    private static final Logger log = LoggerFactory.getLogger(CanaisAPI.class);
    private static final Locale pt_PT = Locale.forLanguageTag("pt-pt");
    private long startScheduling = 0L;
    private long endScheduling = Long.MAX_VALUE;
    private String id;
    @JsonProperty(value="noticias_id")
    private String noticiasId;
    @JsonProperty(value="noticias_slug")
    private String noticiasSlug;
    private String name;
    private String description;
    private String type;
    private String slug;
    private String preTitle;
    @JsonProperty(value="postitle")
    private String posTitle;
    private String title;
    private String url;
    private Image thumb;
    private String status;
    @JsonProperty(value="author_id")
    private String authorId;
    @JsonProperty(value="partner_id")
    private String partnerId;
    @JsonProperty(value="sponsor_id")
    private List<String> sponsorIds;
    private List<CanaisAPI> fullSponsorIds;
    private String excerpt;
    private String content;
    private String body;
    private boolean blink = false;
    @JsonProperty(value="highlight_type")
    private String highlightType;
    @JsonProperty(value="highlight_value")
    private String highlightValue;
    @JsonProperty(value="video_url")
    private String videoUrl;
    private List<String> pages;
    private int totalPages;
    @JsonProperty(value="publish_date")
    private String publishDate;
    @JsonProperty(value="update_date")
    private String updateDate;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="start_date")
    private String startDate;
    @JsonProperty(value="end_date")
    private String endDate;
    private List<Block> blocks;
    private Metadata metadata;
    private List<Categories> categories;
    private List<Embeds> embeds;
    private List<Tag> tags;
    private Taxonomies taxonomies;
    private Map<String, Translation> translations;
    private Multimedia multimedia;
    private ContentInfo contentInfo;
    private boolean externalLink;
    private DynamicData dynamicData;

    public CanaisAPI() {
    }

    public CanaisAPI(String st) {
    }

    public long getStartScheduling() {
        return this.startScheduling;
    }

    public void setStartScheduling(long startScheduling) {
        this.startScheduling = startScheduling;
    }

    public long getEndScheduling() {
        return this.endScheduling;
    }

    public void setEndScheduling(long endScheduling) {
        this.endScheduling = endScheduling;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNoticiasId() {
        return this.noticiasId;
    }

    public void setNoticiasId(String noticiasId) {
        this.noticiasId = noticiasId;
    }

    public String getNoticiasSlug() {
        return this.noticiasSlug;
    }

    public void setNoticiasSlug(String noticiasSlug) {
        this.noticiasSlug = noticiasSlug;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.preTitle = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type.equals("photo_gallery")) {
            this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
            this.multimedia.setPhotoGallery(true);
        }
        if (type.equals("recipe")) {
            this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
            this.multimedia.setRecipe(true);
        }
        this.type = type;
    }

    public String getSlug() {
        return this.slug;
    }

    public void setSlug(String slug) {
        this.slug = slug;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPreTitle() {
        return this.preTitle;
    }

    public void setPreTitle(String preTitle) {
        this.preTitle = preTitle;
    }

    public String getPosTitle() {
        return this.posTitle;
    }

    public void setPosTitle(String posTitle) {
        this.posTitle = posTitle;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (url != null && url.startsWith("/cinema/salas/")) {
            url = url.replace("/cinema/salas/", "/cinema/em-cartaz/sala/");
        }
        this.url = url;
    }

    public void setThumbnail(List<Image> thumbnail) {
        if (thumbnail != null && thumbnail.size() > 0) {
            this.thumb = thumbnail.get(0);
        }
    }

    public Image getThumb() {
        return this.thumb;
    }

    @JsonProperty(value="thumbnail")
    public void setThumb(Image thumb) {
        this.thumb = thumb;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(String authorId) {
        this.authorId = authorId;
    }

    public String getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(String partnerId) {
        this.partnerId = partnerId;
    }

    public List<String> getSponsorIds() {
        return this.sponsorIds;
    }

    public void setSponsorIds(List<String> sponsorIds) {
        this.sponsorIds = sponsorIds;
    }

    public List<CanaisAPI> getFullSponsorIds() {
        return this.fullSponsorIds;
    }

    public void setFullSponsorIds(List<CanaisAPI> fullSponsorIds) {
        this.fullSponsorIds = fullSponsorIds;
    }

    public String getExcerpt() {
        return this.excerpt;
    }

    public void setExcerpt(String excerpt) {
        this.excerpt = excerpt;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        if (!StringUtils.isEmpty((CharSequence)content)) {
            if (this.contentInfo == null) {
                this.contentInfo = new ContentInfo();
            }
            if (this.contentInfo != null && this.contentInfo.getNumWords() == 0L) {
                this.contentInfo.setNumWords(content.split("\\s+").length);
            }
        }
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public boolean getBlink() {
        return this.blink;
    }

    public void setBlink(String blink) {
        this.blink = blink.equals("1") || blink.equalsIgnoreCase("true");
    }

    public String getHighlightType() {
        return this.highlightType;
    }

    public void setHighlightType(String highlightType) {
        this.highlightType = highlightType;
        if (highlightType.equals("podcast")) {
            this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
            this.multimedia.setHasPodcast(true);
        }
    }

    public String getHighlightValue() {
        return this.highlightValue;
    }

    public void setHighlightValue(String highlightValue) {
        this.highlightValue = highlightValue;
    }

    public String getVideoUrl() {
        return this.videoUrl;
    }

    public void setVideoUrl(String videoUrl) {
        this.videoUrl = videoUrl;
        this.highlightValue = videoUrl;
        if (!StringUtils.isEmpty((CharSequence)this.videoUrl)) {
            if (this.multimedia == null) {
                this.multimedia = new Multimedia();
            }
            if (this.metadata == null) {
                this.metadata = new Metadata();
            }
            this.getMetadata().setSapoVideosUrl(this.videoUrl);
            this.getMultimedia().setHasVideo(true);
        }
    }

    public List<String> getPages() {
        return this.pages;
    }

    public void setPages(List<String> pages) {
        this.totalPages = pages.size();
        this.pages = pages;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public String getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(String publishDate) {
        this.publishDate = publishDate;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(String updateDate) {
        this.updateDate = updateDate;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
        this.publishDate = createdAt;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(List<Block> blocks) {
        this.blocks = blocks;
        if (this.blocks != null && !this.blocks.isEmpty()) {
            for (Block blockItem : this.blocks) {
                String slug = "block-" + blockItem.getPosition();
                if (blockItem.getAttributes() != null && !StringUtils.isEmpty((CharSequence)blockItem.getAttributes().getTitle())) {
                    slug = String.valueOf(slug) + "-" + Slug.create(blockItem.getAttributes().getTitle());
                }
                if (!StringUtils.isEmpty((CharSequence)blockItem.getType())) {
                    slug = blockItem.getType().equals("placeholder") ? String.valueOf(slug) + "-" + blockItem.getAttributes().getPlaceholderType() : String.valueOf(slug) + "-" + Slug.create(blockItem.getType());
                }
                blockItem.setSlug(slug);
            }
        }
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        long epoch;
        if (!StringUtils.isEmpty((CharSequence)this.videoUrl)) {
            if (this.multimedia == null) {
                this.multimedia = new Multimedia();
            }
            if (this.metadata == null) {
                this.metadata = new Metadata();
            }
            metadata.setSapoVideosUrl(this.videoUrl);
            this.getMultimedia().setHasVideo(true);
        }
        if (!StringUtils.isEmpty((CharSequence)metadata.getStartDate()) && (epoch = this.getEpoch(metadata.getStartDate(), "yyyy-MM-dd HH:mm:ss")) > 0L) {
            this.startScheduling = epoch;
        }
        if (!StringUtils.isEmpty((CharSequence)metadata.getEndDate()) && (epoch = this.getEpoch(metadata.getEndDate(), "yyyy-MM-dd HH:mm:ss")) > 0L) {
            this.endScheduling = epoch;
        }
        if (!StringUtils.isEmpty((CharSequence)metadata.getPhotoGalleryId())) {
            this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
            this.multimedia.setHasPhotoGallery(true);
            if (!StringUtils.isEmpty((CharSequence)metadata.getArticleType()) && metadata.getArticleType().equals("PHOTOGALLERY")) {
                this.multimedia.setPhotoGallery(true);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)metadata.getVideoGalleryId())) {
            this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
            this.multimedia.setHasVideoGallery(true);
        }
        if (!StringUtils.isEmpty((CharSequence)metadata.getArticleType())) {
            if (metadata.getArticleType().equals("LIVE_BLOG")) {
                this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                this.multimedia.setHasLiveBlog(true);
            }
            if (metadata.getArticleType().equals("LONGFORM")) {
                this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                this.multimedia.setHasLongform(true);
            }
            if (metadata.getArticleType().equals("VIDEO")) {
                this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                this.multimedia.setVideo(true);
            }
            if (metadata.getArticleType().equals("AUDIO")) {
                this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                this.multimedia.setAudio(true);
                if (metadata.getFullMultimedia() != null && metadata.getFullMultimedia().getDynamicData() != null && metadata.getFullMultimedia().getDynamicData().getMapString() != null && !metadata.getFullMultimedia().getDynamicData().getMapString().isEmpty() && metadata.getFullMultimedia().getDynamicData().getMapString().get("audio_lenght_sec") != null) {
                    if (this.contentInfo == null) {
                        this.contentInfo = new ContentInfo();
                    }
                    this.contentInfo.setDurationAudioSeconds(Long.valueOf(metadata.getFullMultimedia().getDynamicData().getMapString().get("audio_lenght_sec")));
                }
            }
        }
        if (metadata.getFullPhotoGallery() != null && metadata.getFullPhotoGallery().getMetadata() != null && metadata.getFullPhotoGallery().getMetadata().getPhotos() != null) {
            if (this.contentInfo == null) {
                this.contentInfo = new ContentInfo();
            }
            this.contentInfo.setTotalPhotos(metadata.getFullPhotoGallery().getMetadata().getPhotos().size());
        }
        if (!StringUtils.isEmpty((CharSequence)metadata.getSponsorName())) {
            this.title = metadata.getSponsorName();
        }
        this.dynamicData = metadata.getDynamicData();
        this.metadata = metadata;
    }

    public List<Categories> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Categories> categories) {
        this.categories = categories;
    }

    public List<Embeds> getEmbeds() {
        return this.embeds;
    }

    @JsonProperty(value="embeds")
    public void setUnparsedEmbeds(List<Object> embeds) {
        ArrayList<Embeds> listEmbeds = new ArrayList<Embeds>();
        if (embeds.size() > 0) {
            Embeds parsedEmbeds = new Embeds();
            HashMap<String, Embed> lstEmbed = new HashMap<String, Embed>();
            try {
                Map unparsedEmbeds = (Map)embeds.get(0);
                Set unparsedKeys = unparsedEmbeds.keySet();
                JsonConverter<Embed> mapper = new JsonConverter<Embed>(Embed.class);
                for (String key : unparsedKeys) {
                    Embed json = null;
                    Object unparsedEmbed = unparsedEmbeds.get(key);
                    json = mapper.convertValue(unparsedEmbed);
                    if (json == null) continue;
                    lstEmbed.put(key, json);
                }
            }
            catch (Exception e) {
                log.error("Parsing embeds", (Throwable)e);
            }
            parsedEmbeds.setLstEmbed(lstEmbed);
            listEmbeds.add(parsedEmbeds);
        }
        this.setEmbeds(listEmbeds);
    }

    public void setEmbeds(List<Embeds> embeds) {
        if (embeds.size() > 0) {
            for (Map.Entry<String, Embed> item : embeds.get(0).getLstEmbed().entrySet()) {
                if (item.getValue().getType().equals("video")) {
                    this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                    this.multimedia.setHasVideo(true);
                    if (item.getValue().getAttributes().size() > 0 && !StringUtils.isEmpty((CharSequence)item.getValue().getAttributes().get(0).getData())) {
                        Metadata metadata = this.metadata = this.metadata == null ? new Metadata() : this.metadata;
                        if (StringUtils.isEmpty((CharSequence)this.metadata.getRandname())) {
                            if (this.contentInfo == null) {
                                this.contentInfo = new ContentInfo();
                            }
                            this.contentInfo.setDurationVideoSeconds(item.getValue().getAttributes().get(0).getDurationInSeconds());
                            this.metadata.setRandname(item.getValue().getAttributes().get(0).getData().substring(item.getValue().getAttributes().get(0).getData().length() - 20));
                        }
                    }
                }
                if (!item.getValue().getType().equals("related-post") || item.getValue().getAttributes() == null || !item.getValue().getAttributes().isEmpty() || item.getValue().getAttributes().get(0).getType() == null || !item.getValue().getAttributes().get(0).getType().equals("multimedia")) continue;
                this.multimedia = this.multimedia == null ? new Multimedia() : this.multimedia;
                this.multimedia.setHasAudio(true);
            }
        }
        this.embeds = embeds;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public Taxonomies getTaxonomies() {
        return this.taxonomies;
    }

    public void setTaxonomies(Taxonomies taxonomies) {
        this.taxonomies = taxonomies;
        if (taxonomies != null && taxonomies.getTag() != null && !taxonomies.getTag().isEmpty()) {
            this.tags = taxonomies.getTag();
        }
    }

    @JsonProperty(value="translations")
    public void setTranslationNode(JsonNode translationNode) {
        if (translationNode.toString().equals("[]") || translationNode.toString().equals("{}")) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        HashMap<String, Translation> translations = new HashMap<String, Translation>();
        Iterator iter = translationNode.fields();
        while (iter.hasNext()) {
            Map.Entry element = (Map.Entry)iter.next();
            translations.put((String)element.getKey(), (Translation)mapper.convertValue(element.getValue(), Translation.class));
        }
        if (!translations.isEmpty()) {
            this.translations = translations;
        }
    }

    public Map<String, Translation> getTranslations() {
        return this.translations;
    }

    public void setTranslations(Map<String, Translation> translations) {
        this.translations = translations;
    }

    public Multimedia getMultimedia() {
        return this.multimedia;
    }

    public void setMultimedia(Multimedia multimedia) {
        this.multimedia = multimedia;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public void setContentInfo(ContentInfo contentInfo) {
        this.contentInfo = contentInfo;
    }

    public boolean isExternalLink() {
        return this.externalLink;
    }

    public void setExternalLink(boolean externalLink) {
        this.externalLink = externalLink;
    }

    public DynamicData getDynamicData() {
        return this.dynamicData;
    }

    public void setDynamicData(DynamicData dynamicData) {
        this.dynamicData = dynamicData;
    }

    private long getEpoch(String date, String format) {
        try {
            return new SimpleDateFormat(format, pt_PT).parse(date).getTime();
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public String toString() {
        return "CanaisAPI [startScheduling=" + this.startScheduling + ", endScheduling=" + this.endScheduling + ", id=" + this.id + ", noticiasId=" + this.noticiasId + ", noticiasSlug=" + this.noticiasSlug + ", name=" + this.name + ", description=" + this.description + ", type=" + this.type + ", slug=" + this.slug + ", preTitle=" + this.preTitle + ", posTitle=" + this.posTitle + ", title=" + this.title + ", url=" + this.url + ", thumb=" + this.thumb + ", status=" + this.status + ", authorId=" + this.authorId + ", partnerId=" + this.partnerId + ", sponsorIds=" + this.sponsorIds + ", fullSponsorIds=" + this.fullSponsorIds + ", excerpt=" + this.excerpt + ", content=" + this.content + ", body=" + this.body + ", blink=" + this.blink + ", highlightType=" + this.highlightType + ", highlightValue=" + this.highlightValue + ", videoUrl=" + this.videoUrl + ", pages=" + this.pages + ", totalPages=" + this.totalPages + ", publishDate=" + this.publishDate + ", updateDate=" + this.updateDate + ", createdAt=" + this.createdAt + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", blocks=" + this.blocks + ", metadata=" + this.metadata + ", categories=" + this.categories + ", embeds=" + this.embeds + ", tags=" + this.tags + ", taxonomies=" + this.taxonomies + ", translations=" + this.translations + ", multimedia=" + this.multimedia + ", contentInfo=" + this.contentInfo + ", externalLink=" + this.externalLink + ", dynamicData=" + this.dynamicData + "]";
    }
}

