/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools;

import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class ThumbsEpic {
    private static final String THUMB_URL = "//thumbs.web.sapo.io";
    private static final byte[] AES_KEY = "88f1bfa0ffa70edd02e656348a19e1ab".getBytes();
    private static final String IV_SUFFIX = "eu vi um sapo";
    private static final ThumbsEpic instance = new ThumbsEpic();
    private final SecretKey aesKey;
    private final Base64.Encoder b64_encoder;
    static final int MAX_THUMB_SIZE = 2100;

    private ThumbsEpic() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);
            try {
                field.set(null, Boolean.FALSE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.aesKey = new SecretKeySpec(AES_KEY, "AES");
            this.b64_encoder = Base64.getEncoder();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private String doCreate(String url) {
        if (url != null && url.startsWith("//")) {
            url = String.format("http:%s", url);
        }
        try {
            String ivstart = ThumbsEpic.hash(url).substring(0, 3);
            byte[] iv = (String.valueOf(ivstart) + IV_SUFFIX).getBytes();
            IvParameterSpec iv_spec = new IvParameterSpec(iv);
            String b64_ivstart = this.b64_encoder.encodeToString(ivstart.getBytes());
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)this.aesKey, iv_spec);
            byte[] buf_cipher_text = cipher.doFinal(url.getBytes());
            String b64_cipher_text = this.b64_encoder.encodeToString(buf_cipher_text);
            return b64_ivstart.concat(b64_cipher_text);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String hash(String in) throws NoSuchAlgorithmException {
        MessageDigest m = MessageDigest.getInstance("MD5");
        m.update(in.getBytes());
        return new BigInteger(1, m.digest()).toString(16);
    }

    public static String create(String url) {
        return instance.doCreate(url);
    }

    public static String create(String url, String w, String h) {
        String epic = ThumbsEpic.create(url);
        int _w = Integer.parseInt(w);
        int _h = Integer.parseInt(h);
        _w = Math.min(_w, 2100);
        if ((_h = Math.min(_h, 2100)) > _w) {
            return String.format("//thumbs.web.sapo.io/?H=%d&epic=%s&png=1", _h, epic);
        }
        if (_w >= _h) {
            return String.format("//thumbs.web.sapo.io/?W=%d&epic=%s&png=1", _w, epic);
        }
        return String.format("//thumbs.web.sapo.io/?W=%s&H=%s&epic=%s&png=1", _w, _h, epic);
    }

    public static String createMB(String url, String w, String h) {
        String epic = ThumbsEpic.create(url);
        int _w = Integer.parseInt(w);
        int _h = Integer.parseInt(h);
        _w = Math.min(_w, 2100);
        if ((_h = Math.min(_h, 2100)) > _w) {
            return String.format("//thumbs.web.sapo.io/?H=%d&epic=%s&delay_optim=1&png=1&tv=1", _h, epic);
        }
        if (_w >= _h) {
            return String.format("//thumbs.web.sapo.io/?W=%d&epic=%s&delay_optim=1&png=1&tv=1", _w, epic);
        }
        return String.format("//thumbs.web.sapo.io/?W=%s&H=%s&epic=%s&delay_optim=1&png=1&tv=1", w, h, epic);
    }

    public static String createMBOptions(String url, String w, String h, String options) {
        String resp = "";
        try {
            url = StringUtils.defaultString((String)url, (String)"");
            String ext = null;
            String isPng = "";
            ext = StringUtils.substringAfterLast((String)url, (String)".");
            if (!StringUtils.isEmpty((CharSequence)ext) && StringUtils.lowerCase((String)ext).equals("png")) {
                isPng = "&png=1";
            }
            String epic = ThumbsEpic.create(url);
            int _w = Integer.parseInt(w);
            int _h = Integer.parseInt(h);
            _w = Math.min(_w, 2100);
            _h = Math.min(_h, 2100);
            resp = String.format("//thumbs.web.sapo.io/?W=%s&H=%s%s%s&epic=%s", _w, _h, isPng, options, epic);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        return resp;
    }

    public static String create(String url, String w, String h, String crop) {
        String epic = ThumbsEpic.create(url);
        return String.format("//thumbs.web.sapo.io/?W=%s&H=%s&crop=%s&png=1&epic=%s", w, h, crop, epic);
    }

    public static String createMB(String url, String w, String h, String crop) {
        int _w = Integer.parseInt(w);
        int _h = Integer.parseInt(h);
        _w = Math.min(_w, 2100);
        _h = Math.min(_h, 2100);
        String epic = ThumbsEpic.create(url);
        return String.format("//thumbs.web.sapo.io/?W=%s&H=%s&crop=%s&delay_optim=1&png=1&tv=1&epic=%s", _w, _h, crop, epic);
    }

    public static String createMBW(String url, String w) {
        String epic = ThumbsEpic.create(url);
        return String.format("//thumbs.web.sapo.io/?W=%sepic=%s&delay_optim=1&png=1&tv=1", w, epic);
    }

    public static String createMBH(String url, String h) {
        String epic = ThumbsEpic.create(url);
        return String.format("//thumbs.web.sapo.io/?H=%s&epic=%s&delay_optim=1&png=1&tv=1", h, epic);
    }
}

