/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools.sapodesporto;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.sapodesporto.RecordItem;
import pt.sapo.sapofe.api.sapodesporto.SportStatisticsApi;
import pt.sapo.sapofe.api.sapodesporto.SportStatisticsApiList;
import pt.sapo.sapofe.api.sapodesporto.SportStatisticsStructuredApi;
import pt.sapo.sapofe.tools.sapodesporto.JsonSportStatisticsListResponseHandler;
import pt.sapo.sapofe.tools.sapodesporto.JsonSportStatisticsRecordItemResponseHandler;
import pt.sapo.sapofe.tools.sapodesporto.JsonSportStatisticsResponseHandler;
import pt.sapo.sapofe.tools.sapodesporto.JsonSportStatisticsStructuredResponseHandler;

public class SportHttpClient {
    private static Logger log = LoggerFactory.getLogger(SportHttpClient.class);
    static PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpclient;
    private final JsonSportStatisticsResponseHandler rsp_sportstatistics_handler = new JsonSportStatisticsResponseHandler();
    private final JsonSportStatisticsListResponseHandler rsp_sportstatisticslist_handler = new JsonSportStatisticsListResponseHandler();
    private final JsonSportStatisticsStructuredResponseHandler rsp_sportstatisticsstructured_handler = new JsonSportStatisticsStructuredResponseHandler();
    private final JsonSportStatisticsRecordItemResponseHandler rsp_sportstatisticsrecorditem_handler = new JsonSportStatisticsRecordItemResponseHandler();

    static {
        cm.setMaxTotal(10);
        String value = System.getenv("http_proxy");
        RequestConfig config = null;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            HttpHost proxy = new HttpHost(StringUtils.substringBefore((String)value, (String)":"), Integer.parseInt(StringUtils.substringAfter((String)value, (String)":")), "http");
            config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(10000).setConnectTimeout(5000).build();
        } else {
            config = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(5000).build();
        }
        httpclient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }

    private SportStatisticsApi doHttpRequestSportStatistics(HttpRequestBase httpget, JsonSportStatisticsResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (SportStatisticsApi)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_sportstatistics_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Sport - %s%n", r.getMessage()));
            return null;
        }
    }

    public SportStatisticsApi doGetSportStatistics(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestSportStatistics((HttpRequestBase)httpget, this.rsp_sportstatistics_handler);
    }

    private SportStatisticsApiList doHttpRequestSportStatisticsList(HttpRequestBase httpget, JsonSportStatisticsListResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (SportStatisticsApiList)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_sportstatisticslist_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Sport - %s%n", r.getMessage()));
            return null;
        }
    }

    public SportStatisticsApiList doGetSportStatisticsList(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestSportStatisticsList((HttpRequestBase)httpget, this.rsp_sportstatisticslist_handler);
    }

    private SportStatisticsStructuredApi doHttpRequestSportStatisticsStructured(HttpRequestBase httpget, JsonSportStatisticsStructuredResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (SportStatisticsStructuredApi)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_sportstatisticsstructured_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Sport - %s%n", r.getMessage()));
            return null;
        }
    }

    public SportStatisticsStructuredApi doGetSportStatisticsStructured(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestSportStatisticsStructured((HttpRequestBase)httpget, this.rsp_sportstatisticsstructured_handler);
    }

    private RecordItem doHttpRequestSportStatisticsRecordItem(HttpRequestBase httpget, JsonSportStatisticsRecordItemResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (RecordItem)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_sportstatisticsrecorditem_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Sport - %s%n", r.getMessage()));
            return null;
        }
    }

    public RecordItem doGetSportStatisticsRecordItem(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestSportStatisticsRecordItem((HttpRequestBase)httpget, this.rsp_sportstatisticsrecorditem_handler);
    }
}

