/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api.app.homepage;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import pt.sapo.sapofe.api.app.homepage.ItemApp;
import pt.sapo.sapofe.tools.ThumbsEpic;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"id", "title", "type", "items"})
public class EmbedApp
implements Serializable,
Cloneable {
    @JsonProperty(value="id")
    protected String id;
    @JsonProperty(value="title")
    protected String title;
    @JsonProperty(value="type")
    protected String type;
    @JsonProperty(value="items")
    protected List<ItemApp> items = null;
    @JsonIgnore
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    protected static final long serialVersionUID = 3822529801190880005L;
    @JsonProperty(value="ampHtml")
    protected String ampHtml;

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="items")
    public List<ItemApp> getItems() {
        return this.items;
    }

    @JsonProperty(value="items")
    public void setItems(List<ItemApp> items) {
        this.items = items;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("title", (Object)this.title).append("type", (Object)this.type).append("items", this.items).append("additionalProperties", this.additionalProperties).toString();
    }

    public void setAmpHtml(String ampHtml) {
        this.ampHtml = ampHtml;
    }

    public String generateEmbed(EmbedApp embed) {
        switch (embed.type) {
            case "instagram": {
                return this.generateAmpHtmlInstagram(embed);
            }
            case "twitter": {
                return this.generateAmpHtmlTwitter(embed);
            }
            case "gallery": 
            case "photo-gallery": {
                return this.generateAmpHtmlPhotoGallery(embed);
            }
            case "video": {
                return this.videoIframe(embed);
            }
            case "caption": {
                return this.generateAmpHtmlCaption(embed);
            }
        }
        this.ampHtml = "";
        return "";
    }

    private String generateAmpHtmlInstagram(EmbedApp embed) {
        String pattern = "([^:\\/\\s]+)((\\/\\w+)*\\/)?$";
        Pattern regex = Pattern.compile(pattern);
        String embedString = "";
        if (embed.getItems() != null && embed.getItems().size() > 0) {
            Matcher m;
            String url = embed.getItems().get(0).getUrl();
            if (url.lastIndexOf("/") == url.length() - 1) {
                url = StringUtils.substringBeforeLast((String)url, (String)"/");
            }
            if ((m = regex.matcher(url)).find()) {
                embedString = "<amp-instagram width=\"1\" height=\"1\" layout=\"responsive\" data-shortcode=\"" + m.group(0) + "\"> </amp-instagram>";
            }
        }
        return embedString;
    }

    private String generateAmpHtmlTwitter(EmbedApp embed) {
        String pattern = "([^:\\/\\s]+)((\\/\\w+)*\\/)?$";
        Pattern regex = Pattern.compile(pattern);
        String embedString = "";
        if (embed.getItems() != null && embed.getItems().size() > 0) {
            Matcher m;
            String url = embed.getItems().get(0).getUrl();
            if (url.lastIndexOf("/") == url.length() - 1) {
                url = StringUtils.substringBeforeLast((String)url, (String)"/");
            }
            if ((m = regex.matcher(url)).find()) {
                String twitterId = StringUtils.substringBefore((String)m.group(0), (String)"?");
                embedString = "<amp-twitter width=\"1200\" height=\"600\" layout=\"responsive\" data-tweetid=\"" + twitterId + "\"> </amp-twitter>";
            }
        }
        return embedString;
    }

    private String generateAmpHtmlPhotoGallery(EmbedApp embed) {
        String embedString = "";
        embedString = embedString + "<div class=\"gallery\" >";
        embedString = embedString + "<amp-carousel lightbox width=\"1200\" height=\"600\" layout=\"responsive\" type=\"slides\" delay=\"3000\">";
        if (embed.getItems() != null) {
            for (ItemApp image : embed.getItems()) {
                if (StringUtils.isEmpty((CharSequence)image.getUrl())) continue;
                embedString = embedString + "<amp-img src=\"" + image.getUrl() + "\" width=\"auto\" height=\"auto\" layout=\"responsive\">";
                if (!StringUtils.isEmpty((CharSequence)image.getDescription())) {
                    embedString = embedString + "<span class=\"overlay-text\" style=\"position: absolute;bottom: 1rem;left: 1rem;right: 1rem;z-index: 1;pointer-events: none;background-color: #222;color: #fff;padding: .5rem;border-radius: 2px;opacity: 0.7;\">" + image.getDescription() + "</span>";
                }
                embedString = embedString + "</amp-img>";
            }
        }
        embedString = embedString + "</amp-carousel>";
        embedString = embedString + "</div>";
        return embedString;
    }

    private String videoIframe(EmbedApp embed) {
        String embedString = "";
        if (embed.getItems() != null && embed.getItems().size() > 0) {
            String encId = "1";
            embedString = "<amp-iframe width=\"640\" height=\"360\" layout=\"responsive\" sandbox=\"allow-scripts allow-same-origin allow-popups\" allowfullscreen frameborder=\"0\" src=\"https://rd.videos.sapo.pt/playhtml?file=%s/mov/%s\"></amp-iframe>";
            embedString = String.format(embedString, StringUtils.remove((String)embed.getItems().get(0).getUrl(), (String)"/mov/1"), encId);
        }
        return embedString;
    }

    private String generateAmpHtmlCaption(EmbedApp embed) {
        String embedString = "";
        if (embed.getItems() != null && embed.getItems().size() > 0) {
            String imgSrc = embed.getItems().get(0).getUrl();
            imgSrc = ThumbsEpic.createMBOptions(imgSrc, "1200", "600", "&delay_optim=1&tv=1&crop=center");
            String imgTitle = embed.getItems().get(0).getTitle();
            embedString = "<amp-img src=\"" + imgSrc + "\" width=\"1200\" height=\"600\" layout=\"responsive\" alt=\"" + imgTitle + "\"></amp-img>";
        }
        return embedString;
    }

    public String getAmpHtml() {
        return this.generateEmbed(this);
    }
}

