/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools.emprego;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.sapoemprego.EmpregoApi;
import pt.sapo.sapofe.tools.emprego.JsonEmpregoResponseHandler;

public class EmpregoHttpClient {
    private static Logger log = LoggerFactory.getLogger(EmpregoHttpClient.class);
    static PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpclient;
    private final JsonEmpregoResponseHandler rsp_emprego_handler = new JsonEmpregoResponseHandler();

    private EmpregoApi doHttpRequestEmpregoApi(HttpRequestBase httpget, JsonEmpregoResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            EmpregoApi result = (EmpregoApi)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_emprego_handler, (HttpContext)context);
            log.info(String.format("TIME: [ %sms ] \t REQUEST: %s ", System.currentTimeMillis() - startTime, httpget.getURI()));
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to EmpregoApi - %s%n", r.getMessage()));
            return null;
        }
    }

    private EmpregoApi doHttpRequestEmpregoApi(HttpUriRequest request, JsonEmpregoResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            EmpregoApi result = (EmpregoApi)httpclient.execute(request, (ResponseHandler)this.rsp_emprego_handler, (HttpContext)context);
            log.info(String.format("TIME: [ %sms ] \t REQUEST: %s ", System.currentTimeMillis() - startTime, request.getURI()));
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to EmpregoApi - %s%n", r.getMessage()));
            return null;
        }
    }

    public EmpregoApi doGetEmpregoApi(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestEmpregoApi((HttpRequestBase)httpget, this.rsp_emprego_handler);
    }

    public EmpregoApi doGetEmpregoApi(String api_url, String authorization, String filter) {
        StringEntity entity = null;
        entity = new StringEntity(filter, ContentType.APPLICATION_JSON);
        HttpUriRequest request = RequestBuilder.get().setUri(api_url).setHeader("Authorization", authorization).setEntity((HttpEntity)entity).build();
        return this.doHttpRequestEmpregoApi(request, this.rsp_emprego_handler);
    }

    static {
        cm.setMaxTotal(10);
        String value = System.getenv("http_proxy");
        RequestConfig config = null;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            HttpHost proxy = new HttpHost(StringUtils.substringBefore((String)value, (String)":"), Integer.parseInt(StringUtils.substringAfter((String)value, (String)":")), "http");
            config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(10000).setConnectTimeout(5000).build();
        } else {
            config = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(5000).build();
        }
        httpclient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

