/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools.social;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.social.InstagramAPI;
import pt.sapo.sapofe.tools.shopk.ShopkHttpClient;
import pt.sapo.sapofe.tools.social.JsonListInstagramResponseHandler;

public class SocialHttpClient {
    private static Logger log = LoggerFactory.getLogger(ShopkHttpClient.class);
    static PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpclient;
    private final JsonListInstagramResponseHandler rsp_list_instagram_handler = new JsonListInstagramResponseHandler();

    private InstagramAPI doHttpRequestListResult(HttpRequestBase httpget, JsonListInstagramResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (InstagramAPI)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_list_instagram_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            log.error(String.format("Can't execute call to Canais API - %s%n", r.getMessage()));
            return null;
        }
    }

    public InstagramAPI doGetListResult(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestListResult((HttpRequestBase)httpget, this.rsp_list_instagram_handler);
    }

    static {
        cm.setMaxTotal(10);
        String value = System.getenv("http_proxy");
        RequestConfig config = null;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            HttpHost proxy = new HttpHost(StringUtils.substringBefore((String)value, (String)":"), Integer.parseInt(StringUtils.substringAfter((String)value, (String)":")), "http");
            config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(2500).setConnectTimeout(1000).build();
        } else {
            config = RequestConfig.custom().setSocketTimeout(2500).setConnectTimeout(1000).build();
        }
        httpclient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

