/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.CanaisAPI;
import pt.sapo.sapofe.api.Categories;
import pt.sapo.sapofe.api.MainMenuApiList;
import pt.sapo.sapofe.api.Newspaper;
import pt.sapo.sapofe.api.sapovideos.Video;
import pt.sapo.sapofe.api.sapovideos.VideoObj;
import pt.sapo.sapofe.tools.Constants;

public class NewsDb
implements Serializable {
    private static final long serialVersionUID = -3173774769371117459L;
    private static final Logger log = LoggerFactory.getLogger(NewsDb.class);
    private static NewsDb instance = new NewsDb();
    private Map<String, MainMenuApiList> menusBySlug;
    private Map<String, CanaisAPI> blockPagesBySlug;
    private Map<String, CanaisAPI> blockPagesByUrl;
    private Map<String, Categories> categoriesBySlug;
    private Map<String, CanaisAPI> partnersBySlug;
    private Map<String, CanaisAPI> authorsBySlug;
    private Map<String, CanaisAPI> authorsRolesBySlug;
    private Map<String, CanaisAPI> dossiersById;
    private Map<String, CanaisAPI> sponsorsBySlug;
    private Map<String, CanaisAPI> countysById;
    private ArrayList<CanaisAPI> popularArticles;
    private ArrayList<CanaisAPI> latestArticles;
    private Map<String, CanaisAPI> socialBySlug;
    private ArrayList<CanaisAPI> playlists;
    private CanaisAPI mainHighlights;
    private ArrayList<String> articlesOnHP;
    private Map<String, CanaisAPI> itemBySlug;
    private Map<String, List<CanaisAPI>> mapGenericListCanaisApi;
    private Map<String, List<VideoObj>> mapGenericVideoListApi;
    private Map<String, List<Newspaper>> mapGenericNewspaperApi;
    private Map<String, List<Video>> mapGenericVideoList;
    private Date lastModified;
    public static final String KEY_ASTRAL_ARTICLES = "astralArticles";
    public static final String KEY_ASTRAL_VIDEOS = "astralVideos";

    /*
     * Exception decompiling
     */
    private NewsDb() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static synchronized void dump(NewsDb adb) {
        boolean IS_DOCKER_PROJECT = Constants.properties.getProperty("is.docker.project", "false").equals("true");
        File outFile = new File("./news.db.tmp");
        try (FileOutputStream fileOut = new FileOutputStream(outFile);
             ObjectOutputStream out = new ObjectOutputStream(fileOut);){
            out.writeObject(adb);
            out.close();
            fileOut.close();
            String cacheFolder = Constants.properties.getProperty("db.path", "./");
            String projectName = System.getProperty("project", null);
            String fileName = cacheFolder + (projectName != null ? projectName + "-" : "") + "news.db";
            File dstFile = new File(fileName);
            if (IS_DOCKER_PROJECT) {
                cacheFolder = Constants.properties.getProperty("db.path", "./");
                String copyFileName = cacheFolder + (projectName != null ? projectName + "-" : "") + "news.db";
                Path targetFile = Paths.get(copyFileName, new String[0]);
                Path targetFileAux = Paths.get(copyFileName + ".tmp", new String[0]);
                log.info("DUMP: move REPLACE_EXISTING from:" + outFile + " TO: " + targetFileAux);
                Files.move(outFile.toPath(), targetFileAux, StandardCopyOption.REPLACE_EXISTING);
                log.info("DUMP: move from:" + targetFileAux + " TO: " + targetFile);
                Files.move(targetFileAux, targetFile, StandardCopyOption.ATOMIC_MOVE);
            } else {
                Files.move(outFile.toPath(), dstFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
            }
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static final void build(Map<String, MainMenuApiList> _lstMenus, Map<String, CanaisAPI> _lstBlockPages, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstAuthorsRoles, Map<String, CanaisAPI> _lstDossiers, Map<String, CanaisAPI> _lstSponsors, Map<String, CanaisAPI> _lstCountys, ArrayList<CanaisAPI> _lstPopularArticles, ArrayList<CanaisAPI> _lstLatestArticles, Map<String, CanaisAPI> _lstSocial, ArrayList<CanaisAPI> _lstPlaylists, CanaisAPI _mainHighlights, ArrayList<String> _lstArticlesOnHP, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, List<CanaisAPI>> _mapGenericListCanaisApi, Map<String, List<VideoObj>> _mapGenericVideoListApi, Map<String, List<Newspaper>> _mapGenericNewspaperApi, Map<String, List<Video>> _mapGenericVideoList) {
        NewsDb adb = new NewsDb(_lstMenus, _lstBlockPages, _lstCategories, _lstPartners, _lstAuthors, _lstAuthorsRoles, _lstDossiers, _lstSponsors, _lstCountys, _lstPopularArticles, _lstLatestArticles, _lstSocial, _lstPlaylists, _mainHighlights, _lstArticlesOnHP, _lstPagesBySlug, _mapGenericListCanaisApi, _mapGenericVideoListApi, _mapGenericNewspaperApi, _mapGenericVideoList);
        NewsDb.dump(adb);
        instance = adb;
    }

    public static final void build(InputStream input) {
        NewsDb.build(input, true);
    }

    public static final void build(InputStream input, boolean saveDbFile) {
        try (ObjectInputStream in = new ObjectInputStream(input);){
            NewsDb adb = (NewsDb)in.readObject();
            if (saveDbFile) {
                NewsDb.dump(adb);
            }
            instance = adb;
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }

    public static final synchronized void revive() {
        log.info("revive(NewsDb)");
        try {
            int randInt = new Random().nextInt(4) * 1000;
            Thread.sleep(randInt + 2000);
            NewsDb newsDb = new NewsDb();
            if (newsDb != null) {
                instance = new NewsDb();
            }
        }
        catch (InterruptedException e) {
            log.info("NEWS DB REVIVE: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public NewsDb(Map<String, MainMenuApiList> _lstMenus, Map<String, CanaisAPI> _lstBlockPages, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstAuthorsRoles, Map<String, CanaisAPI> _lstDossiers, Map<String, CanaisAPI> _lstSponsors, Map<String, CanaisAPI> _lstCountys, ArrayList<CanaisAPI> _lstPopularArticles, ArrayList<CanaisAPI> _lstLatestArticles, Map<String, CanaisAPI> _lstSocial, ArrayList<CanaisAPI> _lstPlaylists, CanaisAPI _mainHighlights, ArrayList<String> _lstArticlesOnHP, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, List<CanaisAPI>> _mapGenericListCanaisApi, Map<String, List<VideoObj>> _mapGenericVideoListApi, Map<String, List<Newspaper>> _mapGenericNewspaperApi, Map<String, List<Video>> _mapGenericVideoList) {
        this.lastModified = new Date();
        this.init(_lstMenus, _lstBlockPages, _lstCategories, _lstPartners, _lstAuthors, _lstAuthorsRoles, _lstDossiers, _lstSponsors, _lstCountys, _lstPopularArticles, _lstLatestArticles, _lstSocial, _lstPlaylists, _mainHighlights, _lstArticlesOnHP, _lstPagesBySlug, _mapGenericListCanaisApi, _mapGenericVideoListApi, _mapGenericNewspaperApi, _mapGenericVideoList);
    }

    private void init(Map<String, MainMenuApiList> _lstMenus, Map<String, CanaisAPI> _lstBlockPages, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstAuthorsRoles, Map<String, CanaisAPI> _lstDossiers, Map<String, CanaisAPI> _lstSponsors, Map<String, CanaisAPI> _lstCountys, ArrayList<CanaisAPI> _lstPopularArticles, ArrayList<CanaisAPI> _lstLatestArticles, Map<String, CanaisAPI> _lstSocial, ArrayList<CanaisAPI> _lstPlaylists, CanaisAPI _mainHighlights, ArrayList<String> _lstArticlesOnHP, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, List<CanaisAPI>> _mapGenericListCanaisApi, Map<String, List<VideoObj>> _mapGenericVideoListApi, Map<String, List<Newspaper>> _mapGenericNewspaperApi, Map<String, List<Video>> _mapGenericVideoList) {
        this.menusBySlug = new HashMap<String, MainMenuApiList>();
        this.blockPagesBySlug = new HashMap<String, CanaisAPI>();
        this.blockPagesByUrl = new HashMap<String, CanaisAPI>();
        this.categoriesBySlug = new HashMap<String, Categories>();
        this.partnersBySlug = new HashMap<String, CanaisAPI>();
        this.authorsBySlug = new HashMap<String, CanaisAPI>();
        this.authorsRolesBySlug = new HashMap<String, CanaisAPI>();
        this.dossiersById = new HashMap<String, CanaisAPI>();
        this.sponsorsBySlug = new HashMap<String, CanaisAPI>();
        this.countysById = new HashMap<String, CanaisAPI>();
        this.popularArticles = new ArrayList();
        this.latestArticles = new ArrayList();
        this.socialBySlug = new HashMap<String, CanaisAPI>();
        this.playlists = new ArrayList();
        this.mainHighlights = new CanaisAPI();
        this.articlesOnHP = new ArrayList();
        this.itemBySlug = new HashMap<String, CanaisAPI>();
        this.mapGenericListCanaisApi = new HashMap<String, List<CanaisAPI>>();
        this.mapGenericVideoListApi = new HashMap<String, List<VideoObj>>();
        this.mapGenericNewspaperApi = new HashMap<String, List<Newspaper>>();
        this.fillLookupTables(_lstMenus, _lstBlockPages, _lstCategories, _lstPartners, _lstAuthors, _lstAuthorsRoles, _lstDossiers, _lstSponsors, _lstCountys, _lstPopularArticles, _lstLatestArticles, _lstSocial, _lstPlaylists, _mainHighlights, _lstArticlesOnHP, _lstPagesBySlug, _mapGenericListCanaisApi, _mapGenericVideoListApi, _mapGenericNewspaperApi, _mapGenericVideoList);
        this.lastModified = new Date();
    }

    private void fillLookupTables(Map<String, MainMenuApiList> _lstMenus, Map<String, CanaisAPI> _lstBlockPages, Map<String, Categories> _lstCategories, Map<String, CanaisAPI> _lstPartners, Map<String, CanaisAPI> _lstAuthors, Map<String, CanaisAPI> _lstAuthorsRoles, Map<String, CanaisAPI> _lstDossiers, Map<String, CanaisAPI> _lstSponsors, Map<String, CanaisAPI> _lstCountys, ArrayList<CanaisAPI> _lstPopularArticles, ArrayList<CanaisAPI> _lstLatestArticles, Map<String, CanaisAPI> _lstSocial, ArrayList<CanaisAPI> _lstPlaylists, CanaisAPI _mainHighlights, ArrayList<String> _lstArticlesOnHP, Map<String, CanaisAPI> _lstPagesBySlug, Map<String, List<CanaisAPI>> _mapGenericListCanaisApi, Map<String, List<VideoObj>> _mapGenericVideoListApi, Map<String, List<Newspaper>> _mapGenericNewspaperApi, Map<String, List<Video>> _mapGenericVideoList) {
        this.menusBySlug = _lstMenus;
        this.blockPagesBySlug = _lstBlockPages;
        this.blockPagesByUrl = this.fillBlockPageByUrl(this.blockPagesBySlug);
        this.categoriesBySlug = _lstCategories;
        this.partnersBySlug = _lstPartners;
        this.authorsBySlug = _lstAuthors;
        this.authorsRolesBySlug = _lstAuthorsRoles;
        this.dossiersById = _lstDossiers;
        this.sponsorsBySlug = _lstSponsors;
        this.countysById = _lstCountys;
        this.popularArticles = _lstPopularArticles;
        this.latestArticles = _lstLatestArticles;
        this.socialBySlug = _lstSocial;
        this.playlists = _lstPlaylists;
        this.mainHighlights = _mainHighlights;
        this.articlesOnHP = _lstArticlesOnHP;
        this.itemBySlug = _lstPagesBySlug;
        this.mapGenericListCanaisApi = _mapGenericListCanaisApi;
        this.mapGenericVideoListApi = _mapGenericVideoListApi;
        this.mapGenericNewspaperApi = _mapGenericNewspaperApi;
        this.mapGenericVideoList = _mapGenericVideoList;
    }

    private Map<String, CanaisAPI> fillBlockPageByUrl(Map<String, CanaisAPI> _blockPagesBySlug) {
        HashMap<String, CanaisAPI> _blockPagesByUrl = new HashMap<String, CanaisAPI>();
        for (Map.Entry<String, CanaisAPI> entry : _blockPagesBySlug.entrySet()) {
            CanaisAPI _blockPage = entry.getValue();
            if (_blockPage == null || StringUtils.isEmpty((CharSequence)_blockPage.getUrl())) continue;
            _blockPagesByUrl.put(_blockPage.getUrl(), _blockPage);
        }
        return _blockPagesByUrl;
    }

    public static final Map<String, MainMenuApiList> getAllMenus() {
        return instance.doGetMenus();
    }

    public static final Map<String, CanaisAPI> getAllBlockPagesBySlug() {
        return instance.doGetBlockPagesBySlug();
    }

    public static final Map<String, Categories> getCategories() {
        return instance.doGetCategories();
    }

    public static final Map<String, CanaisAPI> getPartners() {
        return instance.doGetPartners();
    }

    public static final Map<String, CanaisAPI> getAuthors() {
        return instance.doGetAuthors();
    }

    public static final Map<String, CanaisAPI> getAuthorsRoles() {
        return instance.doGetAuthorsRoles();
    }

    public static final Map<String, CanaisAPI> getDossiers() {
        return instance.doGetDossiers();
    }

    public static final Map<String, CanaisAPI> getSponsors() {
        return instance.doGetSponsors();
    }

    public static final Map<String, CanaisAPI> getCountys() {
        return instance.doGetCountys();
    }

    public static final ArrayList<CanaisAPI> getPopularArticles() {
        return instance.doGetPopularArticles();
    }

    public static final ArrayList<CanaisAPI> getLatestArticles() {
        return instance.doGetLatestArticles();
    }

    public static final ArrayList<CanaisAPI> getPlaylists() {
        return instance.doGetPlaylists();
    }

    public static final CanaisAPI getMainHighlights() {
        return instance.doGetMainHighlights();
    }

    public static final ArrayList<String> getArticlesOnHP() {
        return instance.doGetArticlesOnHP();
    }

    public static final Map<String, CanaisAPI> getSocial() {
        return instance.doGetSocial();
    }

    public static final CanaisAPI getItemBySlug(String slug) {
        return instance.doGetItemBySlug(slug);
    }

    public static final Map<String, CanaisAPI> getAllItemBySlug() {
        return instance.doGetAllItemBySlug();
    }

    public static final Map<String, List<CanaisAPI>> getMapGenericListCanaisApi() {
        return instance.doGetMapGenericListCanaisApi();
    }

    public static final Map<String, List<VideoObj>> getMapGenericVideoListApi() {
        return instance.doGetMapGenericVideoListApi();
    }

    public static final Map<String, List<Newspaper>> getMapGenericNewspaperApi() {
        return instance.doGetMapGenericNewspaperApi();
    }

    public static Map<String, List<Video>> getMapGenericVideoList() {
        return NewsDb.instance.mapGenericVideoList;
    }

    private Map<String, MainMenuApiList> doGetMenus() {
        return this.menusBySlug;
    }

    private Map<String, CanaisAPI> doGetBlockPagesBySlug() {
        return this.blockPagesBySlug;
    }

    private Map<String, Categories> doGetCategories() {
        return this.categoriesBySlug;
    }

    private Map<String, CanaisAPI> doGetPartners() {
        return this.partnersBySlug;
    }

    private Map<String, CanaisAPI> doGetAuthors() {
        return this.authorsBySlug;
    }

    private Map<String, CanaisAPI> doGetAuthorsRoles() {
        return this.authorsRolesBySlug;
    }

    private Map<String, CanaisAPI> doGetDossiers() {
        return this.dossiersById;
    }

    private Map<String, CanaisAPI> doGetSponsors() {
        return this.sponsorsBySlug;
    }

    private Map<String, CanaisAPI> doGetCountys() {
        return this.countysById;
    }

    private ArrayList<CanaisAPI> doGetPopularArticles() {
        return this.popularArticles;
    }

    private ArrayList<CanaisAPI> doGetLatestArticles() {
        return this.latestArticles;
    }

    private Map<String, CanaisAPI> doGetSocial() {
        return this.socialBySlug;
    }

    private ArrayList<CanaisAPI> doGetPlaylists() {
        return this.playlists;
    }

    private CanaisAPI doGetMainHighlights() {
        return this.mainHighlights;
    }

    private ArrayList<String> doGetArticlesOnHP() {
        return this.articlesOnHP;
    }

    private Map<String, CanaisAPI> doGetAllItemBySlug() {
        return this.itemBySlug;
    }

    private CanaisAPI doGetItemBySlug(String slug) {
        return this.itemBySlug.get(slug);
    }

    private Map<String, List<CanaisAPI>> doGetMapGenericListCanaisApi() {
        return this.mapGenericListCanaisApi;
    }

    private Map<String, List<VideoObj>> doGetMapGenericVideoListApi() {
        return this.mapGenericVideoListApi;
    }

    private Map<String, List<Newspaper>> doGetMapGenericNewspaperApi() {
        return this.mapGenericNewspaperApi;
    }

    public static final Date getLastModified() {
        return instance.doGetLastModified();
    }

    private Date doGetLastModified() {
        return this.lastModified;
    }

    public static CanaisAPI getArticleBySlug(String slug) {
        return NewsDb.instance.itemBySlug.get(slug);
    }

    public static Map<String, CanaisAPI> getBlockPages() {
        return NewsDb.instance.blockPagesBySlug;
    }

    public static CanaisAPI getBlockPageBySlug(String slug) {
        return NewsDb.instance.blockPagesBySlug.get(slug);
    }

    public static CanaisAPI getBlockPageByUrl(String url) {
        return NewsDb.instance.blockPagesByUrl.get(url);
    }

    public static Map<String, CanaisAPI> getBrands() {
        return new HashMap<String, CanaisAPI>();
    }
}

