/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.api.app.homepage;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import pt.sapo.sapofe.api.CanaisAPI;
import pt.sapo.sapofe.api.Producer;
import pt.sapo.sapofe.api.app.homepage.EmbedApp;
import pt.sapo.sapofe.api.app.homepage.PhotoApp;
import pt.sapo.sapofe.api.app.homepage.VideosApp;
import pt.sapo.sapofe.api.saponoticias.InternalRefs;
import pt.sapo.sapofe.api.saponoticias.Meta;
import pt.sapo.sapofe.api.saponoticias.News;
import pt.sapo.sapofe.api.saponoticias.Source;
import pt.sapo.sapofe.tools.Constants;
import pt.sapo.sapofe.tools.ThumbsEpic;

@JsonPropertyOrder(value={"partner", "partnerName", "partnerCpid", "author", "category", "id", "title", "lead", "body", "photo", "imageEpic", "video", "source", "image", "url", "dateTime", "article", "Embeds", "partner", "partnerName", "author", "category", "id", "title", "lead", "body", "photo", "imageEpic", "source", "url", "dateTime", "article", "Embeds"})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NoticiaApp
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4954683256104797584L;
    private String id;
    private String title;
    private String lead;
    private String body;
    private String video;
    private String source;
    private Source sources;
    private String url;
    private String dateTime;
    protected String[] categories;
    private String category;
    private Meta author;
    @JsonProperty(value="Embeds")
    private List<EmbedApp> embeds;
    private List<PhotoApp> photos;
    private String photo;
    @JsonProperty(value="image")
    private LinkedHashMap<String, Object> image;
    @JsonProperty(value="imageEpic")
    private String imageEpic;
    private Producer producer;
    private String partner;
    private String partnerName;
    private String partnerCpid;
    private String sponsor;
    private String sponsorName;
    private Double nClicks;
    private InternalRefs iRef;
    private List<VideosApp> videos;
    @JsonProperty(value="article")
    private NoticiaApp article;
    @JsonProperty(value="Content")
    private News content;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public News getContent() {
        return this.content;
    }

    public void setContent(News content) {
        this.content = content;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="_id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonSetter(value="Title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonGetter(value="lead")
    public String getLead() {
        return this.lead;
    }

    @JsonSetter(value="Lead")
    public void setLead(String lead) {
        this.lead = lead;
    }

    @JsonGetter(value="body")
    public String getBody() {
        return this.body;
    }

    @JsonSetter(value="Body")
    public void setBody(String body) {
        this.body = body;
    }

    @JsonGetter(value="source")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @JsonGetter(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonSetter(value="URL")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonGetter(value="dateTime")
    public String getDateTime() {
        return this.dateTime;
    }

    @JsonSetter(value="DateTime")
    public void setDateTime(String date) {
        this.dateTime = date;
    }

    public NoticiaApp getArticle() {
        return this.article;
    }

    public void setArticle(NoticiaApp article) {
        this.article = article;
    }

    @JsonSetter(value="Categories")
    public void setCategories(String[] categories) {
        this.categories = categories;
        if (categories.length > 0) {
            this.setCategory(categories[0].toLowerCase(Locale.ROOT));
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @JsonGetter(value="author")
    public String getAuthor() {
        if (this.author != null) {
            return this.author.getName();
        }
        return null;
    }

    @JsonSetter(value="Author")
    public void setAuthor(Meta author) {
        this.author = author;
    }

    public List<EmbedApp> getEmbeds() {
        return this.embeds;
    }

    public void setEmbeds(List<EmbedApp> embeds) {
        this.embeds = embeds;
    }

    public List<PhotoApp> getPhotos() {
        return this.photos;
    }

    @JsonGetter(value="photo")
    public String getPhoto() {
        return this.photo;
    }

    @JsonSetter(value="Photos")
    public void setPhoto(List<PhotoApp> photo) {
        this.photo = photo.get(0).getURL();
        if (photo.get(0).getURL() != null) {
            this.setImageEpic(ThumbsEpic.create(photo.get(0).getURL()));
        }
    }

    public String getImageEpic() {
        if (this.photo != null) {
            return ThumbsEpic.create(this.photo);
        }
        return this.imageEpic;
    }

    @JsonSetter(value="Videos")
    public void setVideos(List<VideosApp> videos) {
        this.videos = videos;
    }

    public void setImageEpic(String imageEpic) {
        this.imageEpic = imageEpic;
    }

    public LinkedHashMap<String, Object> getImage() {
        return this.image;
    }

    public void setImage(LinkedHashMap<String, Object> image) {
        this.image = image;
    }

    @JsonGetter(value="video")
    public String getVideo() {
        return this.video;
    }

    public void setVideo(String video) {
        this.video = video;
    }

    @JsonGetter(value="partner")
    public String getPartner() {
        return this.partner;
    }

    @JsonSetter(value="Partner")
    public void setPartner(String partner) {
        this.partner = partner;
    }

    @JsonGetter(value="partnerName")
    public String getPartnerName() {
        return this.partnerName;
    }

    @JsonSetter(value="PartnerName")
    public void setPartnerName(String partnerName) {
        this.partnerName = partnerName;
    }

    @JsonGetter(value="partnerCpid")
    public String getPartnerCpid() {
        return this.partnerCpid;
    }

    @JsonSetter(value="partnerCpid")
    public void setPartnerCpid(String partnerCpid) {
        this.partnerCpid = partnerCpid;
    }

    public String getSponsor() {
        return this.sponsor;
    }

    public void setSponsor(String sponsor) {
        this.sponsor = sponsor;
    }

    public String getSponsorName() {
        return this.sponsorName;
    }

    public void setSponsorName(String sponsorName) {
        this.sponsorName = sponsorName;
    }

    public Double getNClicks() {
        return this.nClicks;
    }

    public void setNClicks(Double nClicks) {
        this.nClicks = nClicks;
    }

    @JsonProperty(value="InternalRefs")
    public void setiRef(InternalRefs iRef) {
        this.iRef = iRef;
    }

    @JsonIgnore
    public InternalRefs getiRef() {
        return this.iRef;
    }

    @JsonSetter(value="Producer")
    public void setProducer(Producer producer) {
        this.producer = producer;
    }

    @JsonIgnore
    public Producer getProducer() {
        return this.producer;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public NoticiaApp copy() throws CloneNotSupportedException {
        return (NoticiaApp)this.clone();
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "NoticiaApp [id=" + this.id + ", title=" + this.title + ", lead=" + this.lead + ", body=" + this.body + ", photo=" + this.photo + ", imageEpic=" + this.imageEpic + ", image=" + this.image + ", video=" + this.video + ", source=" + this.source + ", url=" + this.url + ", dateTime=" + this.dateTime + ", partner=" + this.partner + ", partnerName=" + this.partnerName + ", sponsor=" + this.sponsor + ", sponsorName=" + this.sponsorName + ", author=" + this.author + ", nClicks=" + this.nClicks + ", iRef=" + this.iRef + ", article=" + this.article + ", embeds=" + this.embeds + "]";
    }

    public NoticiaApp mapping(NoticiaApp noticia) {
        Meta author = new Meta();
        author.setName(noticia.getAuthor());
        ArrayList<PhotoApp> listPhoto = new ArrayList<PhotoApp>();
        PhotoApp photo = new PhotoApp();
        photo.setURL(noticia.getPhoto());
        listPhoto.add(photo);
        this.setAuthor(author);
        this.setCategory(noticia.getCategory());
        this.setPartner(noticia.getPartner());
        this.setPartnerName(noticia.getPartnerName());
        this.setPartnerCpid(noticia.getPartnerCpid());
        this.setId(noticia.getId());
        this.setTitle(noticia.getTitle());
        this.setUrl(noticia.getUrl());
        this.setLead(noticia.getLead());
        this.setBody(noticia.getBody());
        this.setPhoto(listPhoto);
        this.setImageEpic(noticia.getImageEpic());
        this.setDateTime(noticia.getDateTime());
        this.setEmbeds(noticia.getEmbeds());
        return this;
    }

    public NoticiaApp mapping(NoticiaApp noticia, String type) {
        News content = noticia.getContent();
        ArrayList<PhotoApp> listPhoto = new ArrayList<PhotoApp>();
        PhotoApp photo = new PhotoApp();
        if (type.equals("article")) {
            if (content == null) {
                return new NoticiaApp();
            }
            if (content.getPhotos() != null && content.getPhotos().get(0) != null) {
                photo.setURL(content.getPhotos().get(0).getUrl());
            }
            listPhoto.add(photo);
            this.setId(content.getId());
            this.setTitle(content.getTitle());
            this.setLead(content.getLead());
            this.setUrl(content.getUrl());
            this.setDateTime(content.getDateTime());
            this.setBody(content.getBody());
            this.setPhoto(listPhoto);
            this.setSponsor(content.getSponsor());
        } else {
            photo.setURL(noticia.getPhoto());
            listPhoto.add(photo);
            this.setId(noticia.getId());
            this.setTitle(noticia.getTitle());
            this.setLead(noticia.getLead());
            this.setUrl(noticia.getUrl());
            this.setDateTime(noticia.getDateTime());
            this.setBody(noticia.getBody());
            this.setPhoto(listPhoto);
            if (noticia.videos != null) {
                this.setVideo(noticia.videos.get(0).getUrl());
            }
        }
        if (noticia.getSource() != null) {
            this.setSource(noticia.getSource());
        } else if (noticia.producer != null) {
            this.setSource(noticia.producer.getName());
        } else if (noticia.getContent() != null && noticia.getContent().getProducer() != null) {
            this.setSource(noticia.getContent().getProducer().getName());
        }
        this.setPartner(noticia.getPartner());
        this.setPartnerName(noticia.getPartnerName());
        this.setSponsor(noticia.getSponsor());
        this.setSponsorName(noticia.getSponsorName());
        return this;
    }

    public NoticiaApp mapping(NoticiaApp noticia, String type, Boolean article) throws NoSuchAlgorithmException {
        LinkedHashMap<String, Object> resultList = new LinkedHashMap<String, Object>();
        if (Constants.properties.getProperty("cartoon.partners", null).equals(type)) {
            this.setPartner(Constants.properties.getProperty("cartoon.partners", ""));
            this.setPartnerName(Constants.properties.getProperty("cartoon.partners.name", ""));
            this.setTitle(noticia.getTitle());
            this.setUrl(noticia.getUrl());
            String photoUrl = article != false && noticia.getAdditionalProperties().containsKey("HighlightValue") ? (String)noticia.getAdditionalProperties().get("HighlightValue") : noticia.getPhoto();
            if (noticia.getPhoto() != null && photoUrl != null) {
                resultList.put("blinkPretitle", false);
                resultList.put("url", photoUrl);
                resultList.put("epic", ThumbsEpic.create(photoUrl));
                resultList.put("hash", ThumbsEpic.hash(noticia.getUrl()));
                resultList.put("title", noticia.getTitle());
                resultList.put("standOut", false);
                resultList.put("quote", "");
                this.setImage(resultList);
            }
        }
        return this;
    }

    public NoticiaApp mapping(CanaisAPI noticia) {
        ArrayList<PhotoApp> listPhoto = new ArrayList<PhotoApp>();
        PhotoApp photo = new PhotoApp();
        photo.setURL(noticia.getThumb().getUrl());
        listPhoto.add(photo);
        this.setTitle(noticia.getTitle());
        this.setLead(noticia.getExcerpt());
        this.setPhoto(listPhoto);
        this.setImageEpic(ThumbsEpic.create(noticia.getThumb().getUrl()));
        this.setUrl(noticia.getUrl());
        return this;
    }

    public NoticiaApp mapping(CanaisAPI noticia, String type) {
        ArrayList<PhotoApp> listPhoto = new ArrayList<PhotoApp>();
        PhotoApp photo = new PhotoApp();
        listPhoto.add(photo);
        photo.setURL(noticia.getThumb().getUrl());
        this.setId(noticia.getId());
        this.setUrl(noticia.getUrl());
        this.setTitle(noticia.getTitle());
        this.setLead(StringUtils.isEmpty((CharSequence)noticia.getExcerpt()) ? noticia.getMetadata().getSubject() : noticia.getExcerpt());
        this.setPhoto(listPhoto);
        if (noticia.getUpdateDate() != null) {
            this.setDateTime(noticia.getUpdateDate());
        } else if (noticia.getPublishDate() != null) {
            this.setDateTime(noticia.getPublishDate());
        }
        if (noticia.getMetadata() != null && noticia.getMetadata().getHighlightedPost() != null) {
            this.setBody(noticia.getMetadata().getHighlightedPost().getContent());
        } else if (type.equals("agora")) {
            this.setBody("");
        }
        return this;
    }

    public Source getSources() {
        return this.sources;
    }

    @JsonSetter(value="Source")
    public void setSources(Source sources) {
        if (sources != null) {
            this.setSource(sources.getName());
        }
    }
}

