/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.caudexorigo.Shutdown;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Constants {
    private static final Logger log = LoggerFactory.getLogger(Constants.class);
    public static final String[] STATIC_ASSETS_EXTENSIONS = new String[]{"ico", "txt", "xml", "html", "htm", "css", "js", "jpg", "jpeg", "gif", "png", "svg"};
    public static final Properties properties = new Properties();
    public static final Map<Integer, String> monthsSimple = new LinkedHashMap<Integer, String>();
    public static final Map<Integer, String> monthsFullName = new LinkedHashMap<Integer, String>();
    public static String X_SERVER;

    private static List<String> loadParentConfigs(String configName, List<String> loadingConfigsFiles) {
        ResourceBundle initResorce = ResourceBundle.getBundle(configName);
        String loadingConfigs = null;
        try {
            loadingConfigs = initResorce.getString("loading.parents.configs");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (loadingConfigs != null) {
            for (String configFile : StringUtils.split((String)loadingConfigs, (String)";")) {
                loadingConfigsFiles = Constants.loadParentConfigs(configFile, loadingConfigsFiles);
                loadingConfigsFiles.add(configFile);
            }
        }
        return loadingConfigsFiles;
    }

    public static Map<Integer, String> getMonthsSimple() {
        return monthsSimple;
    }

    public static Map<Integer, String> getMonthsFullName() {
        return monthsFullName;
    }

    static {
        monthsSimple.put(1, "jan");
        monthsSimple.put(2, "fev");
        monthsSimple.put(3, "mar");
        monthsSimple.put(4, "abr");
        monthsSimple.put(5, "mai");
        monthsSimple.put(6, "jun");
        monthsSimple.put(7, "jul");
        monthsSimple.put(8, "ago");
        monthsSimple.put(9, "set");
        monthsSimple.put(10, "out");
        monthsSimple.put(11, "nov");
        monthsSimple.put(12, "dez");
        monthsFullName.put(1, "Janeiro");
        monthsFullName.put(2, "Fevereiro");
        monthsFullName.put(3, "Mar\u00e7o");
        monthsFullName.put(4, "Abril");
        monthsFullName.put(5, "Maio");
        monthsFullName.put(6, "Junho");
        monthsFullName.put(7, "Julho");
        monthsFullName.put(8, "Agosto");
        monthsFullName.put(9, "Setembro");
        monthsFullName.put(10, "Outubro");
        monthsFullName.put(11, "Novembro");
        monthsFullName.put(12, "Dezembro");
        String projectName = System.getProperty("project", null);
        String environment = System.getProperty("environment", "staging");
        log.info("CONSTANTS: project name " + projectName);
        log.info("CONSTANTS: loading settings for " + environment);
        try {
            switch (InetAddress.getLocalHost().getHostName()) {
                case "sapo-hp01.hp.bk.sapo.pt": {
                    X_SERVER = "Kalahari";
                    break;
                }
                case "sapo-hp02.hp.bk.sapo.pt": {
                    X_SERVER = "Kara Kum";
                    break;
                }
                case "sapo-hp03.hp.bk.sapo.pt": {
                    X_SERVER = "Bardenas Reales";
                    break;
                }
                case "sapo-hp04.hp.bk.sapo.pt": {
                    X_SERVER = "Mojave";
                    break;
                }
                case "sapo-hp05.hp.bk.sapo.pt": {
                    X_SERVER = "Atacama";
                    break;
                }
                default: {
                    X_SERVER = "Sahara";
                }
            }
            List<String> loadingConfigsFiles = new ArrayList<String>();
            loadingConfigsFiles = Constants.loadParentConfigs((!StringUtils.isEmpty((CharSequence)projectName) ? projectName + "-" : "") + environment, loadingConfigsFiles);
            LinkedHashMap<String, ResourceBundle> _lstResourceBundle = new LinkedHashMap<String, ResourceBundle>();
            for (String string : loadingConfigsFiles) {
                _lstResourceBundle.put(string, ResourceBundle.getBundle(string));
            }
            _lstResourceBundle.put((!StringUtils.isEmpty((CharSequence)projectName) ? projectName + "-" : "") + environment, ResourceBundle.getBundle((!StringUtils.isEmpty((CharSequence)projectName) ? projectName + "-" : "") + environment));
            for (Map.Entry entry : _lstResourceBundle.entrySet()) {
                ResourceBundle resBundle = (ResourceBundle)entry.getValue();
                Enumeration<String> keys = resBundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (resBundle.getString(key) == null || resBundle.getString(key).equals("null") || resBundle.getString(key).equals("")) {
                        properties.remove(key);
                    } else {
                        properties.put(key, resBundle.getString(key));
                    }
                    log.info("CONSTANTS: got: \t'{}' \t=  '{}' ", (Object)key, (Object)resBundle.getString(key));
                }
            }
            HashMap<String, String> overrideProperties = new HashMap<String, String>();
            overrideProperties.put("redis.server.master.host", "REDIS_HOST");
            overrideProperties.put("redis.server.master.port", "REDIS_PORT");
            overrideProperties.put("redis.server.master.pass", "REDIS_PASSWORD");
            overrideProperties.put("redis.key", "REDIS_PREFIX");
            System.out.println("_________________________________________________");
            for (Map.Entry entry : overrideProperties.entrySet()) {
                if (!StringUtils.isNotEmpty((CharSequence)System.getenv((String)entry.getValue()))) continue;
                properties.remove(entry.getKey());
                properties.put(entry.getKey(), System.getenv((String)entry.getValue()));
                System.out.println((String)entry.getKey() + ": " + properties.get(entry.getKey()));
            }
            System.out.println("_________________________________________________");
        }
        catch (Throwable t) {
            Shutdown.now((Throwable)t);
        }
    }
}

