/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.caudexorigo.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.CanaisAPI;
import pt.sapo.sapofe.api.CanaisFacetsAPI;
import pt.sapo.sapofe.api.CanaisListAPI;
import pt.sapo.sapofe.api.CategoriesList;
import pt.sapo.sapofe.api.MainMenuApiList;
import pt.sapo.sapofe.api.Newspaper;
import pt.sapo.sapofe.api.app.homepage.NoticiaApp;
import pt.sapo.sapofe.api.saponoticias.News;
import pt.sapo.sapofe.api.sapovideos.SAPOVideos;
import pt.sapo.sapofe.api.sapovideos.Video;
import pt.sapo.sapofe.tools.Constants;
import pt.sapo.sapofe.tools.IHttpClient;
import pt.sapo.sapofe.tools.JsonCanaisApiResponseHandler;
import pt.sapo.sapofe.tools.JsonCanaisFacetsApiResponseHandler;
import pt.sapo.sapofe.tools.JsonCanaisListApiResponseHandler;
import pt.sapo.sapofe.tools.JsonCategoriesApiResponseHandler;
import pt.sapo.sapofe.tools.JsonListCanaisApiResponseHandler;
import pt.sapo.sapofe.tools.JsonMainMenuApiResponseHandler;
import pt.sapo.sapofe.tools.JsonNewsListApiResponseHandler;
import pt.sapo.sapofe.tools.JsonNewspaperListApiResponseHandler;
import pt.sapo.sapofe.tools.JsonNoticiaListApiResponseHandler;
import pt.sapo.sapofe.tools.JsonSAPOVideosResponseHandler;
import pt.sapo.sapofe.tools.JsonSAPOVideosSingleResponseHandler;
import pt.sapo.sapofe.tools.JsonStringApiResponseHandler;
import pt.sapo.sapofe.tools.Url;

public class HttpClient
implements IHttpClient {
    private static Logger logger = LoggerFactory.getLogger(HttpClient.class);
    static PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpclient;
    private final JsonSAPOVideosSingleResponseHandler rsp_sapovideos_handler = new JsonSAPOVideosSingleResponseHandler();
    private final JsonSAPOVideosResponseHandler rsp_sapovideos_list_handler = new JsonSAPOVideosResponseHandler();
    private final JsonMainMenuApiResponseHandler rsp_main_menu_handler = new JsonMainMenuApiResponseHandler();
    private final JsonCategoriesApiResponseHandler rsp_categories_handler = new JsonCategoriesApiResponseHandler();
    private final JsonCanaisApiResponseHandler rsp_canais_handler = new JsonCanaisApiResponseHandler();
    private final JsonListCanaisApiResponseHandler rsp_list_canais_handler = new JsonListCanaisApiResponseHandler();
    private final JsonCanaisListApiResponseHandler rsp_canais_list_handler = new JsonCanaisListApiResponseHandler();
    private final JsonCanaisFacetsApiResponseHandler rsp_canais_facets_handler = new JsonCanaisFacetsApiResponseHandler();
    private final JsonNewspaperListApiResponseHandler rsp_newspaper_list_handler = new JsonNewspaperListApiResponseHandler();
    private final JsonNewsListApiResponseHandler rsp_news_list_handler = new JsonNewsListApiResponseHandler();
    private final JsonNoticiaListApiResponseHandler rsp_noticia_list_handler = new JsonNoticiaListApiResponseHandler();
    private final JsonStringApiResponseHandler rsp_string_handler = new JsonStringApiResponseHandler();

    public String doHttpJsonPost(String url, String content) {
        HttpPost post = new HttpPost(url);
        try {
            StringEntity entity = new StringEntity(content);
            post.setEntity((HttpEntity)entity);
            post.setHeader("Accept", "application/json");
            post.setHeader("Content-type", "application/json");
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)post);
            Integer status = response.getStatusLine().getStatusCode();
            if (status >= 200 && status < 300) {
                HttpEntity result = response.getEntity();
                if (entity != null) {
                    String jsonResult = IOUtils.toString((InputStream)result.getContent(), (Charset)StandardCharsets.UTF_8);
                    return jsonResult;
                }
                return "";
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    @Override
    public SAPOVideos doHttpGetSAPOVideos(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestSAPOVideos((HttpRequestBase)httpget, this.rsp_sapovideos_list_handler);
    }

    private SAPOVideos doHttpRequestSAPOVideos(HttpRequestBase httpget, JsonSAPOVideosResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            SAPOVideos result = (SAPOVideos)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_sapovideos_list_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to SAPO Videos - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    public Video doHttpGetSAPOVideosSingle(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestSAPOVideosSingle((HttpRequestBase)httpget, this.rsp_sapovideos_handler);
    }

    private Video doHttpRequestSAPOVideosSingle(HttpRequestBase httpget, JsonSAPOVideosSingleResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            Video result = (Video)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_sapovideos_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to SAPO Videos - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    public MainMenuApiList doHttpGetMainMenuAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestMainMenuAPI((HttpRequestBase)httpget, this.rsp_main_menu_handler);
    }

    private MainMenuApiList doHttpRequestMainMenuAPI(HttpRequestBase httpget, JsonMainMenuApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (MainMenuApiList)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_main_menu_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to MENU API - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    @Override
    public CategoriesList doHttpGetCategoriesAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCategoriesAPI((HttpRequestBase)httpget, this.rsp_categories_handler);
    }

    private CategoriesList doHttpRequestCategoriesAPI(HttpRequestBase httpget, JsonCategoriesApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            CategoriesList result = (CategoriesList)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_categories_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to CATEGORIES API - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    public CanaisAPI doHttpGetCanaisAPI(String api_url) {
        api_url = StringUtils.replace((String)api_url, (String)">", (String)Url.enc(">"));
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCanaisAPI((HttpRequestBase)httpget, this.rsp_canais_handler);
    }

    private CanaisAPI doHttpRequestCanaisAPI(HttpRequestBase httpget, JsonCanaisApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            CanaisAPI result = (CanaisAPI)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_canais_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to Canais API - {} - [ {} ]\n", (Object)r.getMessage(), (Object)httpget.getURI());
            return null;
        }
    }

    public ArrayList<CanaisAPI> doHttpGetListCanaisAPI(String api_url) {
        api_url = StringUtils.replace((String)api_url, (String)">", (String)Url.enc(">"));
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestListCanaisAPI((HttpRequestBase)httpget, this.rsp_list_canais_handler);
    }

    private ArrayList<CanaisAPI> doHttpRequestListCanaisAPI(HttpRequestBase httpget, JsonListCanaisApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            ArrayList result = (ArrayList)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_list_canais_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to Canais API - {} - [ {} ]\n", (Object)r.getMessage(), (Object)httpget.getURI());
            return null;
        }
    }

    @Override
    public CanaisListAPI doHttpGetCanaisListAPI(String api_url) {
        api_url = StringUtils.replace((String)api_url, (String)">", (String)Url.enc(">"));
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCanaisListAPI((HttpRequestBase)httpget, this.rsp_canais_list_handler);
    }

    private CanaisListAPI doHttpRequestCanaisListAPI(HttpRequestBase httpget, JsonCanaisListApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            CanaisListAPI result = (CanaisListAPI)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_canais_list_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to Canais API List - {} - [ {} ]\n", (Object)r.getMessage(), (Object)httpget.getURI());
            return null;
        }
    }

    @Override
    public CanaisFacetsAPI doHttpGetCanaisFacetsAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestCanaisFacetsAPI((HttpRequestBase)httpget, this.rsp_canais_facets_handler);
    }

    private CanaisFacetsAPI doHttpRequestCanaisFacetsAPI(HttpRequestBase httpget, JsonCanaisFacetsApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            CanaisFacetsAPI result = (CanaisFacetsAPI)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_canais_facets_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to Canais API - {} - [ {} ]\n", (Object)r.getMessage(), (Object)httpget.getURI());
            return null;
        }
    }

    public Newspaper[] doHttpGetNewspaperAPI(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestNewspaperListAPI((HttpRequestBase)httpget, this.rsp_newspaper_list_handler);
    }

    private Newspaper[] doHttpRequestNewspaperListAPI(HttpRequestBase httpget, JsonNewspaperListApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (Newspaper[])httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_newspaper_list_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to Newspaper API - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    public News[] doHttpGetNews(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestNewsListAPI((HttpRequestBase)httpget, this.rsp_news_list_handler);
    }

    private News[] doHttpRequestNewsListAPI(HttpRequestBase httpget, JsonNewsListApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            News[] result = (News[])httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_news_list_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to News API - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    public NoticiaApp[] doHttpGetNoticia(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestNoticiaListAPI((HttpRequestBase)httpget, this.rsp_noticia_list_handler);
    }

    private NoticiaApp[] doHttpRequestNoticiaListAPI(HttpRequestBase httpget, JsonNoticiaListApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            NoticiaApp[] result = (NoticiaApp[])httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_noticia_list_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to News API - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    @Override
    public String doHttpGetString(String api_url) {
        HttpGet httpget = new HttpGet(api_url);
        return this.doHttpRequestStringAPI((HttpRequestBase)httpget, this.rsp_string_handler);
    }

    public String doHttpGetStringWhithHeaders(String api_url, HashMap<String, String> headers) {
        HttpGet httpget = new HttpGet(api_url);
        headers.forEach((arg_0, arg_1) -> ((HttpGet)httpget).setHeader(arg_0, arg_1));
        return this.doHttpRequestStringAPI((HttpRequestBase)httpget, this.rsp_string_handler);
    }

    private String doHttpRequestStringAPI(HttpRequestBase httpget, JsonStringApiResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            long startTime = System.currentTimeMillis();
            String result = (String)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_string_handler, (HttpContext)context);
            logger.debug("TIME: [ {}ms ] \t REQUEST: {} ", (Object)(System.currentTimeMillis() - startTime), (Object)httpget.getURI());
            return result;
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to News API - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    static {
        cm.setMaxTotal(10);
        String value = System.getenv("http_proxy") != null ? System.getenv("http_proxy") : null;
        RequestConfig config = null;
        int socketTimeout = Integer.parseInt(Constants.properties.getProperty("http.request.socket.timeout", "8000"));
        int connectTimeout = Integer.parseInt(Constants.properties.getProperty("http.request.connect.timeout", "5000"));
        logger.info("socketTimeout [ {} ] ", (Object)socketTimeout);
        logger.info("connectTimeout [ {} ] ", (Object)connectTimeout);
        if (!StringUtils.isEmpty((CharSequence)value)) {
            logger.debug("USE PROXY: {}", (Object)value);
            HttpHost proxy = new HttpHost(StringUtils.substringBefore((String)value, (String)":"), Integer.parseInt(StringUtils.substringAfter((String)value, (String)":")), "http");
            config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(10000).setConnectTimeout(5000).build();
        } else {
            config = RequestConfig.custom().setConnectionRequestTimeout(socketTimeout).setSocketTimeout(socketTimeout).setConnectTimeout(connectTimeout).build();
        }
        httpclient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

