/*
 * Decompiled with CFR 0.152.
 */
package pt.sapo.sapofe.tools.shopk;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.caudexorigo.ErrorAnalyser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.sapo.sapofe.api.shopk.ListProductShopkAPI;
import pt.sapo.sapofe.api.shopk.ProductShopkAPI;
import pt.sapo.sapofe.tools.shopk.JsonProductListShopkResponseHandler;
import pt.sapo.sapofe.tools.shopk.JsonProductSimpleShopkResponseHandler;

public class ShopkHttpClient {
    private static Logger logger = LoggerFactory.getLogger(ShopkHttpClient.class);
    static PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
    private static CloseableHttpClient httpclient;
    private final JsonProductSimpleShopkResponseHandler rsp_product_shopk_handler = new JsonProductSimpleShopkResponseHandler();
    private final JsonProductListShopkResponseHandler rsp_list_product_shopk_handler = new JsonProductListShopkResponseHandler();

    public ProductShopkAPI doGetSingleResult(String api_url, String api_key) {
        HttpGet httpget = new HttpGet(api_url);
        httpget.addHeader("X-API-KEY", api_key);
        return this.doHttpRequestSingleResult((HttpRequestBase)httpget, this.rsp_product_shopk_handler);
    }

    private ProductShopkAPI doHttpRequestSingleResult(HttpRequestBase httpget, JsonProductSimpleShopkResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (ProductShopkAPI)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_product_shopk_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to Pesquisa - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    public ListProductShopkAPI doGetListResult(String api_url, String api_key) {
        HttpGet httpget = new HttpGet(api_url);
        httpget.addHeader("X-API-KEY", api_key);
        return this.doHttpRequestListResult((HttpRequestBase)httpget, this.rsp_list_product_shopk_handler);
    }

    private ListProductShopkAPI doHttpRequestListResult(HttpRequestBase httpget, JsonProductListShopkResponseHandler rsp_handler) {
        BasicHttpContext context = new BasicHttpContext();
        try {
            return (ListProductShopkAPI)httpclient.execute((HttpUriRequest)httpget, (ResponseHandler)this.rsp_list_product_shopk_handler, (HttpContext)context);
        }
        catch (Throwable t) {
            Throwable r = ErrorAnalyser.findRootCause((Throwable)t);
            logger.error("Can't execute call to Canais API - {}\n", (Object)r.getMessage());
            return null;
        }
    }

    static {
        cm.setMaxTotal(10);
        String value = System.getenv("http_proxy");
        RequestConfig config = null;
        if (!StringUtils.isEmpty((CharSequence)value)) {
            HttpHost proxy = new HttpHost(StringUtils.substringBefore((String)value, (String)":"), Integer.parseInt(StringUtils.substringAfter((String)value, (String)":")), "http");
            config = RequestConfig.custom().setProxy(proxy).setSocketTimeout(2500).setConnectTimeout(1000).build();
        } else {
            config = RequestConfig.custom().setSocketTimeout(2500).setConnectTimeout(1000).build();
        }
        httpclient = HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

